/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.fmt.JPropertyFile;
import com.sun.tools.xjc.outline.ClassOutline;
import java.util.Iterator;

public class CodeModelUtils {
    private CodeModelUtils() {
    }

    public static JPropertyFile getOrCreatePropertyFile(JPackage thePackage, String name) {
        JPropertyFile propertyFile = null;
        Iterator iterator = thePackage.propertyFiles();
        while (iterator.hasNext() && null == propertyFile) {
            JResourceFile resourceFile = (JResourceFile)iterator.next();
            if (!(resourceFile instanceof JPropertyFile) || !name.equals(resourceFile.name())) continue;
            propertyFile = (JPropertyFile)resourceFile;
        }
        if (null == propertyFile) {
            propertyFile = new JPropertyFile(name);
            thePackage.addResourceFile((JResourceFile)propertyFile);
        }
        return propertyFile;
    }

    public static String getClassName(JClass theClass) {
        return theClass.outer() == null ? theClass.fullName() : CodeModelUtils.getClassName(theClass.outer()) + "$" + theClass.name();
    }

    public static String getLocalClassName(JClass theClass) {
        return theClass.outer() == null ? theClass.name() : CodeModelUtils.getLocalClassName(theClass.outer()) + "$" + theClass.name();
    }

    public static String getDottedLocalClassName(JClass theClass) {
        return theClass.outer() == null ? theClass.name() : CodeModelUtils.getDottedLocalClassName(theClass.outer()) + "." + theClass.name();
    }

    public static String getPackagedClassName(JClass theClass) {
        return theClass.outer() == null ? theClass.fullName() : CodeModelUtils.getPackagedClassName(theClass.outer()) + "$" + theClass.name();
    }

    public static JClass box(JType t) {
        if (t instanceof JClass) {
            return (JClass)t;
        }
        return ((JPrimitiveType)t).boxify();
    }

    public static JDefinedClass getOrCreateClass(JClassContainer container, int flags, String name) {
        try {
            return container._class(flags, name);
        }
        catch (JClassAlreadyExistsException jcaeex) {
            return jcaeex.getExistingClass();
        }
    }

    public static JDefinedClass getOrCreateClass(JCodeModel codeModel, int flags, String fullClassName) {
        String className;
        String packageName;
        int lastDotIndex = fullClassName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            packageName = fullClassName.substring(0, lastDotIndex);
            className = fullClassName.substring(lastDotIndex + 1);
        } else {
            packageName = "";
            className = fullClassName;
        }
        JPackage thePackage = codeModel._package(packageName);
        return CodeModelUtils.getOrCreateClass((JClassContainer)thePackage, flags, className);
    }

    public static JStatement split(JDefinedClass theClass, JStatement[] statements, String prefix, int start, int length, int threshold) {
        JMethod method = theClass.method(20, (JType)theClass.owner().VOID, prefix);
        if (length < threshold) {
            int index = start;
            while (index - start < length) {
                JStatement statement = statements[index];
                method.body().add(statement);
                ++index;
            }
        } else {
            method.body().add(CodeModelUtils.split(theClass, statements, prefix + "_0", start, length / 2, threshold));
            method.body().add(CodeModelUtils.split(theClass, statements, prefix + "_1", start + length / 2, length - length / 2, threshold));
        }
        return JExpr.invoke((JMethod)method);
    }

    public static JMethod getMethod(JDefinedClass theClass, String name, JType[] arguments) {
        JMethod method = theClass.getMethod(name, arguments);
        if (method != null) {
            return method;
        }
        JClass draftSuperClass = theClass._extends();
        if (draftSuperClass == null || !(draftSuperClass instanceof JDefinedClass)) {
            return null;
        }
        JDefinedClass superClass = (JDefinedClass)draftSuperClass;
        return CodeModelUtils.getMethod(superClass, name, arguments);
    }

    public static JMethod getMethod(JDefinedClass theClass, String name) {
        for (JMethod method : theClass.methods()) {
            if (!method.name().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static JMethod getMethod(ClassOutline classOutline, String name) {
        JDefinedClass ref = classOutline.ref;
        JMethod method = CodeModelUtils.getMethod(ref, name);
        if (method != null) {
            return method;
        }
        ClassOutline superClassOutline = classOutline.getSuperClass();
        if (superClassOutline == null) {
            return null;
        }
        return CodeModelUtils.getMethod(superClassOutline, name);
    }

    public static JCodeModel getCodeModel(ClassOutline classOutline) {
        return classOutline.ref.owner();
    }

    public static JType ref(JCodeModel codeModel, String className) {
        try {
            return codeModel.ref(Thread.currentThread().getContextClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException e) {
            try {
                return codeModel.ref(Class.forName(className));
            }
            catch (ClassNotFoundException e1) {
                JDefinedClass _class = CodeModelUtils._getClass(codeModel, className);
                if (_class != null) {
                    return _class;
                }
                return codeModel.ref(className.replace('$', '.'));
            }
        }
    }

    public static JDefinedClass _getClass(JCodeModel codeModel, String fullyQualifiedName) {
        int idx = fullyQualifiedName.lastIndexOf(46);
        if (idx < 0) {
            return codeModel.rootPackage()._getClass(fullyQualifiedName);
        }
        String packageName = fullyQualifiedName.substring(0, idx);
        Iterator iterator = codeModel.packages();
        while (iterator.hasNext()) {
            JPackage _package = (JPackage)iterator.next();
            if (!packageName.equals(_package.name())) continue;
            return CodeModelUtils._getClass(_package, fullyQualifiedName.substring(idx + 1));
        }
        return null;
    }

    public static JDefinedClass _getClass(JPackage _package, String name) {
        int idx = name.lastIndexOf(36);
        if (idx < 0) {
            return _package._getClass(name);
        }
        String parentClassName = name.substring(0, idx);
        JDefinedClass parentClass = _package._getClass(parentClassName);
        if (parentClass == null) {
            return null;
        }
        return CodeModelUtils._getClass(parentClass, name.substring(idx + 1));
    }

    public static JDefinedClass _getClass(JDefinedClass _class, String name) {
        int idx = name.lastIndexOf(36);
        if (idx < 0) {
            Iterator nestedClasses = _class.classes();
            while (nestedClasses.hasNext()) {
                JDefinedClass nestedClass = (JDefinedClass)nestedClasses.next();
                if (!nestedClass.name().equals(name)) continue;
                return nestedClass;
            }
            return null;
        }
        JDefinedClass nestedClass = CodeModelUtils._getClass(_class, name.substring(0, idx));
        if (nestedClass == null) {
            return null;
        }
        return CodeModelUtils._getClass(nestedClass, name.substring(idx + 1));
    }
}

