/*
 * Decompiled with CFR 0.152.
 */
package japa.parser;

import japa.parser.ASTParser;
import japa.parser.ParseException;
import japa.parser.PositionUtils;
import japa.parser.SourcesHelper;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.Node;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.comments.Comment;
import japa.parser.ast.comments.CommentsCollection;
import japa.parser.ast.comments.CommentsParser;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.Statement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public final class JavaParser {
    private static ASTParser parser;

    private JavaParser() {
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        return JavaParser.parse(in, encoding, true);
    }

    public static CompilationUnit parse(InputStream in, String encoding, boolean considerComments) throws ParseException {
        try {
            String code = SourcesHelper.streamToString(in, encoding);
            InputStream in1 = SourcesHelper.stringToStream(code);
            CompilationUnit cu = new ASTParser(in1, encoding).CompilationUnit();
            if (considerComments) {
                JavaParser.insertComments(cu, code);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, null, true);
    }

    public static CompilationUnit parse(File file, String encoding) throws ParseException, IOException {
        return JavaParser.parse(file, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit parse(File file, String encoding, boolean considerComments) throws ParseException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding, considerComments);
            return compilationUnit;
        }
        finally {
            in.close();
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, null, true);
    }

    public static CompilationUnit parse(Reader reader, boolean considerComments) throws ParseException {
        try {
            String code = SourcesHelper.readerToString(reader);
            Reader reader1 = SourcesHelper.stringToReader(code);
            CompilationUnit cu = new ASTParser(reader1).CompilationUnit();
            if (considerComments) {
                JavaParser.insertComments(cu, code);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static BlockStmt parseBlock(String blockStatement) throws ParseException {
        StringReader sr = new StringReader(blockStatement);
        BlockStmt result = new ASTParser(sr).Block();
        sr.close();
        return result;
    }

    public static Statement parseStatement(String statement) throws ParseException {
        StringReader sr = new StringReader(statement);
        Statement stmt = new ASTParser(sr).Statement();
        sr.close();
        return stmt;
    }

    public static ImportDeclaration parseImport(String importDeclaration) throws ParseException {
        StringReader sr = new StringReader(importDeclaration);
        ImportDeclaration id = new ASTParser(sr).ImportDeclaration();
        sr.close();
        return id;
    }

    public static Expression parseExpression(String expression) throws ParseException {
        StringReader sr = new StringReader(expression);
        Expression e = new ASTParser(sr).Expression();
        sr.close();
        return e;
    }

    public static AnnotationExpr parseAnnotation(String annotation) throws ParseException {
        StringReader sr = new StringReader(annotation);
        AnnotationExpr ae = new ASTParser(sr).Annotation();
        sr.close();
        return ae;
    }

    public static BodyDeclaration parseBodyDeclaration(String body) throws ParseException {
        StringReader sr = new StringReader(body);
        BodyDeclaration bd = new ASTParser(sr).AnnotationBodyDeclaration();
        sr.close();
        return bd;
    }

    private static void insertCommentsInCu(CompilationUnit cu, CommentsCollection commentsCollection) {
        if (commentsCollection.size() == 0) {
            return;
        }
        List<Comment> comments = commentsCollection.getAll();
        PositionUtils.sortByBeginPosition(comments);
        List<Node> children = cu.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        if (cu.getPackage() != null && (children.size() == 0 || PositionUtils.areInOrder(comments.get(0), children.get(0)))) {
            cu.setComment(comments.get(0));
            comments.remove(0);
        }
        JavaParser.insertCommentsInNode(cu, comments);
    }

    private static void insertCommentsInNode(Node node, List<Comment> commentsToAttribute) {
        if (commentsToAttribute.size() == 0) {
            return;
        }
        List<Node> children = node.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        for (Node child : children) {
            LinkedList<Comment> commentsInsideChild = new LinkedList<Comment>();
            for (Comment c : commentsToAttribute) {
                if (!child.contains(c)) continue;
                commentsInsideChild.add(c);
            }
            commentsToAttribute.removeAll(commentsInsideChild);
            JavaParser.insertCommentsInNode(child, commentsInsideChild);
        }
        Comment previousComment = null;
        LinkedList<Comment> attributedComments = new LinkedList<Comment>();
        LinkedList<Node> childrenAndComments = new LinkedList<Node>();
        childrenAndComments.addAll(children);
        childrenAndComments.addAll(commentsToAttribute);
        PositionUtils.sortByBeginPosition(childrenAndComments);
        for (Node thing : childrenAndComments) {
            if (thing instanceof Comment) {
                previousComment = (Comment)thing;
                continue;
            }
            if (previousComment == null) continue;
            thing.setComment(previousComment);
            attributedComments.add(previousComment);
            previousComment = null;
        }
        commentsToAttribute.removeAll(attributedComments);
        for (Comment c : commentsToAttribute) {
            node.addOrphanComment(c);
        }
    }

    private static void insertComments(CompilationUnit cu, String code) throws IOException {
        CommentsParser commentsParser = new CommentsParser();
        CommentsCollection allComments = commentsParser.parse(code);
        JavaParser.insertCommentsInCu(cu, allComments);
    }

    private static void placeOrphanComments(CompilationUnit cu, List<Comment> orphanComments) {
        for (Comment comment : orphanComments) {
            JavaParser.placeOrphanComment(cu, comment);
        }
    }

    private static void placeOrphanComment(Node node, Comment comment) {
        for (Node child : node.getChildrenNodes()) {
            if (!child.contains(comment)) continue;
            JavaParser.placeOrphanComment(child, comment);
            return;
        }
        node.addOrphanComment(comment);
    }
}

