/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.test;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractSamplesTest {
    protected Log logger = LogFactory.getLog(this.getTestClass());
    public static final String DEFAULT_SAMPLES_DIRECTORY_NAME = "src/test/samples";

    protected String getContextPath() {
        return this.getTestClass().getPackage().getName();
    }

    protected abstract void checkSample(File var1) throws Exception;

    @Test
    public void testSamples() throws Exception {
        File[] sampleFiles;
        this.logger.debug((Object)"Testing samples.");
        int failed = 0;
        for (File sampleFile : sampleFiles = this.getSampleFiles()) {
            this.logger.debug((Object)("Testing sample [" + sampleFile.getName() + "]."));
            try {
                this.checkSample(sampleFile);
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Sample [" + sampleFile.getName() + "] failed the check."), ex);
                ++failed;
            }
            this.logger.debug((Object)("Finished testing sample [" + sampleFile.getName() + "]."));
        }
        this.logger.debug((Object)"Finished testing samples.");
        Assertions.assertTrue((failed == 0 ? 1 : 0) != 0, (String)("Totally [" + failed + "/" + sampleFiles.length + "] failed the check."));
    }

    protected File getBaseDir() {
        try {
            return new File(this.getTestClass().getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile().getParentFile().getAbsoluteFile();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected Class<? extends Object> getTestClass() {
        return this.getClass();
    }

    protected File getSamplesDirectory() {
        return new File(this.getBaseDir(), this.getSamplesDirectoryName());
    }

    protected String getSamplesDirectoryName() {
        return DEFAULT_SAMPLES_DIRECTORY_NAME;
    }

    protected File[] getSampleFiles() {
        File samplesDirectory = this.getSamplesDirectory();
        this.logger.debug((Object)("Sample directory [" + samplesDirectory.getAbsolutePath() + "]."));
        return samplesDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name != null && name.endsWith("xml");
            }
        });
    }

    protected ClassLoader getContextClassLoader() {
        return this.getTestClass().getClassLoader();
    }

    protected Map<String, ?> getContextProperties() {
        return null;
    }

    public JAXBContext createContext() throws JAXBException {
        String contextPath = this.getContextPath();
        ClassLoader classLoader = this.getContextClassLoader();
        Map<String, ?> properties = this.getContextProperties();
        if (classLoader == null) {
            return JAXBContext.newInstance((String)contextPath);
        }
        if (properties == null) {
            return JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader);
        }
        return JAXBContext.newInstance((String)contextPath, (ClassLoader)classLoader, properties);
    }
}

