/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.xjc.generator.concrete;

import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Outline;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb.xjc.generator.MClassOutlineGenerator;
import org.jvnet.jaxb.xjc.generator.MElementOutlineGenerator;
import org.jvnet.jaxb.xjc.generator.MEnumOutlineGenerator;
import org.jvnet.jaxb.xjc.generator.MModelOutlineGenerator;
import org.jvnet.jaxb.xjc.generator.MPackageOutlineGenerator;
import org.jvnet.jaxb.xjc.generator.concrete.ClassOutlineGeneratorFactory;
import org.jvnet.jaxb.xjc.generator.concrete.ElementOutlineGeneratorFactory;
import org.jvnet.jaxb.xjc.generator.concrete.EnumOutlineGeneratorFactory;
import org.jvnet.jaxb.xjc.generator.concrete.PackageOutlineGeneratorFactory;
import org.jvnet.jaxb.xjc.outline.MClassOutline;
import org.jvnet.jaxb.xjc.outline.MElementOutline;
import org.jvnet.jaxb.xjc.outline.MEnumOutline;
import org.jvnet.jaxb.xjc.outline.MModelOutline;
import org.jvnet.jaxb.xjc.outline.MPackageOutline;
import org.jvnet.jaxb.xjc.outline.concrete.CMModelOutline;
import org.jvnet.jaxb.xml.bind.model.MClassInfo;
import org.jvnet.jaxb.xml.bind.model.MClassRef;
import org.jvnet.jaxb.xml.bind.model.MClassTypeInfoVisitor;
import org.jvnet.jaxb.xml.bind.model.MElementInfo;
import org.jvnet.jaxb.xml.bind.model.MEnumLeafInfo;
import org.jvnet.jaxb.xml.bind.model.MModelInfo;
import org.jvnet.jaxb.xml.bind.model.MPackageInfo;

public class CMModelOutlineGenerator
implements MModelOutlineGenerator {
    private final Outline outline;
    private final Model model;

    public CMModelOutlineGenerator(Outline outline, Model model) {
        Validate.notNull(outline);
        Validate.notNull(model);
        this.outline = outline;
        this.model = model;
    }

    @Override
    public MModelOutline generate(MModelInfo<NType, NClass> modelInfo) {
        CMModelOutline modelOutline = new CMModelOutline(modelInfo, this.outline.getCodeModel());
        for (MClassInfo<NType, NClass> mClassInfo : modelInfo.getClassInfos()) {
            this.generatePackageOutline(modelOutline, modelInfo, mClassInfo.getPackageInfo());
        }
        for (MElementInfo mElementInfo : modelInfo.getElementInfos()) {
            this.generatePackageOutline(modelOutline, modelInfo, mElementInfo.getPackageInfo());
        }
        for (MEnumLeafInfo mEnumLeafInfo : modelInfo.getEnumLeafInfos()) {
            this.generatePackageOutline(modelOutline, modelInfo, mEnumLeafInfo.getPackageInfo());
        }
        for (MClassInfo mClassInfo : modelInfo.getClassInfos()) {
            this.generateClassOutline(modelOutline, modelInfo, mClassInfo);
        }
        for (MElementInfo mElementInfo : modelInfo.getElementInfos()) {
            this.generateElementOutline(modelOutline, modelInfo, mElementInfo);
        }
        for (MEnumLeafInfo mEnumLeafInfo : modelInfo.getEnumLeafInfos()) {
            this.generateEnumOutline(modelOutline, modelInfo, mEnumLeafInfo);
        }
        return modelOutline;
    }

    private void generatePackageOutline(CMModelOutline modelOutline, MModelInfo<NType, NClass> modelInfo, MPackageInfo packageInfo) {
        if (modelOutline.getPackageOutline(packageInfo) == null && packageInfo.getOrigin() instanceof PackageOutlineGeneratorFactory) {
            MPackageOutlineGenerator generator = (MPackageOutlineGenerator)((PackageOutlineGeneratorFactory)packageInfo.getOrigin()).createGenerator(this.outline);
            MPackageOutline packageOutline = generator.generate(modelOutline, modelInfo, packageInfo);
            modelOutline.addPackageOutline(packageOutline);
        }
    }

    private void generateClassOutline(final CMModelOutline modelOutline, final MModelInfo<NType, NClass> modelInfo, MClassInfo<NType, NClass> classInfo) {
        MClassOutlineGenerator generator;
        MClassOutline classOutline;
        if (classInfo.getBaseTypeInfo() != null) {
            classInfo.getBaseTypeInfo().acceptClassTypeInfoVisitor(new MClassTypeInfoVisitor<NType, NClass, Void>(){

                @Override
                public Void visitClassInfo(MClassInfo<NType, NClass> info) {
                    CMModelOutlineGenerator.this.generateClassOutline(modelOutline, modelInfo, info);
                    return null;
                }

                @Override
                public Void visitClassRef(MClassRef<NType, NClass> info) {
                    return null;
                }
            });
        }
        if (classInfo.getOrigin() instanceof ClassOutlineGeneratorFactory && (classOutline = (generator = (MClassOutlineGenerator)((ClassOutlineGeneratorFactory)classInfo.getOrigin()).createGenerator(this.outline)).generate(modelOutline.getPackageOutline(classInfo.getPackageInfo()), modelInfo, classInfo)) != null) {
            modelOutline.addClassOutline(classOutline);
        }
    }

    private void generateElementOutline(CMModelOutline modelOutline, MModelInfo<NType, NClass> modelInfo, MElementInfo<NType, NClass> elementInfo) {
        MElementOutlineGenerator generator;
        MElementOutline elementOutline;
        if (elementInfo.getOrigin() instanceof ElementOutlineGeneratorFactory && (elementOutline = (generator = (MElementOutlineGenerator)((ElementOutlineGeneratorFactory)elementInfo.getOrigin()).createGenerator(this.outline)).generate(modelOutline.getPackageOutline(elementInfo.getPackageInfo()), modelInfo, elementInfo)) != null) {
            modelOutline.addElementOutline(elementOutline);
        }
    }

    private void generateEnumOutline(CMModelOutline modelOutline, MModelInfo<NType, NClass> modelInfo, MEnumLeafInfo<NType, NClass> enumLeafInfo) {
        MEnumOutlineGenerator generator;
        MEnumOutline enumOutline;
        if (enumLeafInfo.getOrigin() instanceof EnumOutlineGeneratorFactory && (enumOutline = (generator = (MEnumOutlineGenerator)((EnumOutlineGeneratorFactory)enumLeafInfo.getOrigin()).createGenerator(this.outline)).generate(modelOutline.getPackageOutline(enumLeafInfo.getPackageInfo()), modelInfo, enumLeafInfo)) != null) {
            modelOutline.addEnumOutline(enumOutline);
        }
    }
}

