/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.wildcard;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.v2.model.core.WildcardMode;
import org.jvnet.jaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb.plugin.wildcard.Customizations;
import org.jvnet.jaxb.plugin.wildcard.LegacyCustomizations;
import org.jvnet.jaxb.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

public class WildcardPlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xwildcard";
    }

    public String getUsage() {
        return "Allows specifying the wildcard mode in wildcard properties.";
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        boolean laxModel = CustomizationUtils.containsCustomization(model, Customizations.LAX_ELEMENT_NAME) || CustomizationUtils.containsCustomization(model, LegacyCustomizations.LAX_ELEMENT_NAME);
        boolean skipModel = CustomizationUtils.containsCustomization(model, Customizations.SKIP_ELEMENT_NAME) || CustomizationUtils.containsCustomization(model, LegacyCustomizations.SKIP_ELEMENT_NAME);
        boolean strictModel = CustomizationUtils.containsCustomization(model, Customizations.STRICT_ELEMENT_NAME) || CustomizationUtils.containsCustomization(model, LegacyCustomizations.STRICT_ELEMENT_NAME);
        for (CClassInfo classInfo : model.beans().values()) {
            boolean laxClassInfo = CustomizationUtils.containsCustomization(classInfo, Customizations.LAX_ELEMENT_NAME) || CustomizationUtils.containsCustomization(classInfo, LegacyCustomizations.LAX_ELEMENT_NAME);
            boolean skipClassInfo = CustomizationUtils.containsCustomization(classInfo, Customizations.SKIP_ELEMENT_NAME) || CustomizationUtils.containsCustomization(classInfo, LegacyCustomizations.SKIP_ELEMENT_NAME);
            boolean strictClassInfo = CustomizationUtils.containsCustomization(classInfo, Customizations.STRICT_ELEMENT_NAME) || CustomizationUtils.containsCustomization(classInfo, LegacyCustomizations.STRICT_ELEMENT_NAME);
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                boolean strictPropertyInfo;
                if (!(propertyInfo instanceof CReferencePropertyInfo)) continue;
                CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                boolean laxPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, Customizations.LAX_ELEMENT_NAME) || CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, LegacyCustomizations.LAX_ELEMENT_NAME);
                boolean skipPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, Customizations.SKIP_ELEMENT_NAME) || CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, LegacyCustomizations.SKIP_ELEMENT_NAME);
                boolean bl = strictPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, Customizations.STRICT_ELEMENT_NAME) || CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, LegacyCustomizations.STRICT_ELEMENT_NAME);
                if (laxModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                    continue;
                }
                if (skipPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                    continue;
                }
                if (!strictPropertyInfo) continue;
                referencePropertyInfo.setWildcard(WildcardMode.STRICT);
            }
        }
    }

    @Override
    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.LAX_ELEMENT_NAME, Customizations.SKIP_ELEMENT_NAME, Customizations.STRICT_ELEMENT_NAME, LegacyCustomizations.LAX_ELEMENT_NAME, LegacyCustomizations.SKIP_ELEMENT_NAME, LegacyCustomizations.STRICT_ELEMENT_NAME);
    }
}

