/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.xml.bind.model.util;

import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.api.impl.NameConverter;
import org.jvnet.jaxb.lang.Validate;

public class XmlTypeUtils {
    private XmlTypeUtils() {
    }

    public static QName getTypeName(Class<?> targetClass) {
        String namespaceURI;
        String localPart;
        Validate.notNull(targetClass);
        Package targetPackage = targetClass.getPackage();
        XmlType xmlTypeAnnotation = targetClass.getAnnotation(XmlType.class);
        if (xmlTypeAnnotation == null) {
            localPart = NameConverter.standard.toVariableName(targetClass.getSimpleName());
            namespaceURI = XmlTypeUtils.getNamespace(targetPackage);
        } else {
            String name = xmlTypeAnnotation.name();
            localPart = name == null || "".equals(name) ? null : ("##default".equals(name) ? NameConverter.standard.toVariableName(targetClass.getSimpleName()) : name);
            String namespace = xmlTypeAnnotation.namespace();
            namespaceURI = namespace == null || "".equals(namespace) ? "" : ("##default".equals(namespace) ? XmlTypeUtils.getNamespace(targetPackage) : namespace);
        }
        if (localPart == null) {
            return null;
        }
        String prefix = XmlTypeUtils.getPrefix(targetPackage, namespaceURI);
        return prefix == null ? new QName(namespaceURI, localPart) : new QName(namespaceURI, localPart, prefix);
    }

    private static String getPrefix(Package targetPackage, String namespaceURI) {
        XmlSchema xmlSchemaAnnotation;
        HashMap<String, String> namespacePrefixes = new HashMap<String, String>();
        if (targetPackage != null && (xmlSchemaAnnotation = targetPackage.getAnnotation(XmlSchema.class)) != null) {
            for (XmlNs xmlns : xmlSchemaAnnotation.xmlns()) {
                namespacePrefixes.put(xmlns.namespaceURI(), xmlns.prefix());
            }
        }
        String prefix = (String)namespacePrefixes.get(namespaceURI);
        return prefix;
    }

    private static String getNamespace(Package targetPackage) {
        String packageNamespace;
        XmlSchema xmlSchemaAnnotation;
        String namespaceURI = targetPackage == null ? "" : ((xmlSchemaAnnotation = targetPackage.getAnnotation(XmlSchema.class)) == null ? "" : ((packageNamespace = xmlSchemaAnnotation.namespace()) == null || "".equals(packageNamespace) ? "" : packageNamespace));
        return namespaceURI;
    }
}

