/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.namespace_prefix;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStringLiteral;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.generator.bean.PackageOutlineImpl;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIXPluginCustomization;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.impl.SchemaImpl;
import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlSchema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.jaxb.plugin.namespace_prefix.Customizations;
import org.jvnet.jaxb.plugin.namespace_prefix.LegacyCustomizations;
import org.xml.sax.ErrorHandler;

public class NamespacePrefixPlugin
extends Plugin {
    private static Log logger = LogFactory.getLog(NamespacePrefixPlugin.class);

    public String getOptionName() {
        return "Xnamespace-prefix";
    }

    public String getUsage() {
        return "-Xnamespace-prefix : activate namespaces prefix customizations";
    }

    public List<String> getCustomizationURIs() {
        return Arrays.asList(Customizations.NAMESPACE_URI, LegacyCustomizations.NAMESPACE_URI);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return Customizations.NAMESPACE_URI.equals(nsUri) && Customizations.PREFIX_NAME.equals(localName) || LegacyCustomizations.NAMESPACE_URI.equals(nsUri) && LegacyCustomizations.PREFIX_NAME.equals(localName);
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        JClass xmlNsClass = outline.getCodeModel().ref(XmlNs.class);
        JClass xmlSchemaClass = outline.getCodeModel().ref(XmlSchema.class);
        for (PackageOutline packageOutline : outline.getAllPackageContexts()) {
            JPackage p = packageOutline._package();
            Set<String> packageNamespaces = NamespacePrefixPlugin.getPackageNamespace(packageOutline);
            Model packageModel = NamespacePrefixPlugin.getPackageModel((PackageOutlineImpl)packageOutline);
            List<Pair> list = NamespacePrefixPlugin.getPrefixBinding(packageModel, packageNamespaces);
            this.acknowledgePrefixAnnotations(packageModel);
            if (list == null || list.isEmpty()) continue;
            JAnnotationUse xmlSchemaAnnotation = NamespacePrefixPlugin.getOrAddXmlSchemaAnnotation(p, xmlSchemaClass);
            if (xmlSchemaAnnotation == null) {
                throw new RuntimeException("Unable to get/add 'XmlSchema' annotation to package [" + p.name() + "]");
            }
            JAnnotationArrayMember members = xmlSchemaAnnotation.paramArray("xmlns");
            for (Pair pair : list) {
                NamespacePrefixPlugin.addNamespacePrefix(xmlNsClass, members, pair.getNamespace(), pair.getPrefix());
            }
        }
        return true;
    }

    private static Set<String> getPackageNamespace(PackageOutline packageOutline) {
        Map<String, Integer> map = NamespacePrefixPlugin.getUriCountMap(packageOutline);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    private void acknowledgePrefixAnnotations(Model packageModel) {
        CCustomizations customizations = packageModel.getCustomizations();
        if (customizations != null) {
            for (CPluginCustomization customization : customizations) {
                if (customization.element.getNamespaceURI().equals(Customizations.NAMESPACE_URI)) {
                    if (!customization.element.getLocalName().equals(Customizations.PREFIX_NAME)) {
                        throw new RuntimeException("Unrecognized element [" + customization.element.getLocalName() + "]");
                    }
                    customization.markAsAcknowledged();
                    continue;
                }
                if (!customization.element.getNamespaceURI().equals(LegacyCustomizations.NAMESPACE_URI)) continue;
                if (!customization.element.getLocalName().equals(LegacyCustomizations.PREFIX_NAME)) {
                    throw new RuntimeException("Unrecognized element [" + customization.element.getLocalName() + "]");
                }
                logger.warn("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI);
                customization.markAsAcknowledged();
            }
        }
    }

    private static List<Pair> getPrefixBinding(Model packageModel, Set<String> packageNamespace) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (XSSchema schema : packageModel.schemaComponent.getSchemas()) {
            BindInfo b;
            String targetNS;
            Object anno;
            SchemaImpl s = (SchemaImpl)schema;
            XSAnnotation annotation = s.getAnnotation();
            if (annotation == null || (anno = annotation.getAnnotation()) == null || !(anno instanceof BindInfo) || !packageNamespace.contains(targetNS = (b = (BindInfo)anno).getOwner().getOwnerSchema().getTargetNamespace())) continue;
            String prefix = "";
            for (BIDeclaration declaration : b.getDecls()) {
                String targetedPrefix = "";
                String targetedNS = "";
                if (declaration instanceof BIXPluginCustomization) {
                    BIXPluginCustomization customization = (BIXPluginCustomization)declaration;
                    if (customization.element.getNamespaceURI().equals(Customizations.NAMESPACE_URI)) {
                        if (!customization.element.getLocalName().equals(Customizations.PREFIX_NAME)) {
                            throw new RuntimeException("Unrecognized element [" + customization.element.getLocalName() + "]");
                        }
                        targetedPrefix = customization.element.getAttribute("name");
                        targetedNS = customization.element.getAttribute("namespaceURI");
                        customization.markAsAcknowledged();
                    } else if (customization.element.getNamespaceURI().equals(LegacyCustomizations.NAMESPACE_URI)) {
                        if (!customization.element.getLocalName().equals(LegacyCustomizations.PREFIX_NAME)) {
                            throw new RuntimeException("Unrecognized element [" + customization.element.getLocalName() + "]");
                        }
                        logger.warn("Please migrate your namespace in xsd / xjb from " + LegacyCustomizations.NAMESPACE_URI + " to " + Customizations.NAMESPACE_URI);
                        targetedPrefix = customization.element.getAttribute("name");
                        targetedNS = customization.element.getAttribute("namespaceURI");
                        customization.markAsAcknowledged();
                    }
                }
                if (targetedPrefix == null || "".equals(targetedPrefix)) continue;
                if (targetedNS != null && !"".equals(targetedNS) && !targetedNS.equals(targetNS)) {
                    list.add(new Pair(targetedNS, targetedPrefix));
                    continue;
                }
                if (!"".equals(prefix)) continue;
                prefix = targetedPrefix;
            }
            list.add(new Pair(targetNS, prefix));
        }
        return list;
    }

    private static void addNamespacePrefix(JClass xmlNsClass, JAnnotationArrayMember members, String namespace, String prefix) {
        JAnnotationUse ns = members.annotate(xmlNsClass);
        ns.param("namespaceURI", namespace);
        ns.param("prefix", prefix);
    }

    private static JAnnotationUse getOrAddXmlSchemaAnnotation(JPackage p, JClass xmlSchemaClass) {
        JAnnotationUse xmlAnn = null;
        Collection<JAnnotationUse> annotations = NamespacePrefixPlugin.getAnnotations(p);
        if (annotations != null) {
            for (JAnnotationUse annotation : annotations) {
                JClass clazz = NamespacePrefixPlugin.getAnnotationJClass(annotation);
                if (clazz != xmlSchemaClass) continue;
                xmlAnn = annotation;
                break;
            }
        }
        if (xmlAnn == null) {
            xmlAnn = p.annotate(xmlSchemaClass);
        }
        return xmlAnn;
    }

    private static Map<String, Integer> getUriCountMap(PackageOutline packageOutline) {
        try {
            Field field = PackageOutlineImpl.class.getDeclaredField("uriCountMap");
            field.setAccessible(true);
            return (Map)field.get(packageOutline);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to access 'uriCountMap' field for package outline [" + packageOutline._package().name() + "] : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to find 'uriCountMap' field for package outline [" + packageOutline._package().name() + "] : " + e.getMessage(), e);
        }
    }

    private static Model getPackageModel(PackageOutlineImpl packageOutline) {
        try {
            Field field = PackageOutlineImpl.class.getDeclaredField("_model");
            field.setAccessible(true);
            return (Model)field.get(packageOutline);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to access '_model' field for package outline [" + packageOutline._package().name() + "] : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to find '_model' field for package outline [" + packageOutline._package().name() + "] : " + e.getMessage(), e);
        }
    }

    private static Collection<JAnnotationUse> getAnnotations(JPackage p) {
        return p.annotations();
    }

    private static JClass getAnnotationJClass(JAnnotationUse annotation) {
        return annotation.getAnnotationClass();
    }

    private static Map<String, JAnnotationValue> getAnnotationMemberValues(JAnnotationUse annotation) {
        return annotation.getAnnotationMembers();
    }

    private static String getStringAnnotationValue(JAnnotationValue val) {
        try {
            Field clazzField = val.getClass().getDeclaredField("value");
            clazzField.setAccessible(true);
            JStringLiteral j = (JStringLiteral)clazzField.get(val);
            return j == null ? null : j.str;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access 'value' field for class [" + val.getClass() + "] : " + e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to find 'value' field for class [" + val.getClass() + "] : " + e.getMessage(), e);
        }
    }

    private static class Pair {
        private final String namespace;
        private final String prefix;

        private Pair(String namespace, String prefix) {
            this.namespace = namespace;
            this.prefix = prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

