/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.elementwrapper;

import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.plugin.ComposedIgnoring;
import org.jvnet.jaxb.plugin.CustomizedIgnoring;
import org.jvnet.jaxb.plugin.Ignoring;
import org.jvnet.jaxb.plugin.elementwrapper.Customizations;
import org.jvnet.jaxb.plugin.elementwrapper.LegacyCustomizations;
import org.jvnet.jaxb.plugin.model.AbstractModelPlugin;
import org.jvnet.jaxb.xjc.model.concrete.origin.DummyPropertyInfoOrigin;
import org.jvnet.jaxb.xml.bind.model.MClassInfo;
import org.jvnet.jaxb.xml.bind.model.MElementPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.MElementRefPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.MElementRefsPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.MElementsPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.MModelInfo;
import org.jvnet.jaxb.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.concrete.CMElementPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.concrete.CMElementRefPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.concrete.CMElementRefsPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.concrete.CMElementsPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.util.DefaultPropertyInfoVisitor;
import org.jvnet.jaxb.xml.bind.model.util.DefaultTypeInfoVisitor;
import org.xml.sax.ErrorHandler;

public class ElementWrapperPlugin
extends AbstractModelPlugin {
    private Ignoring ignoring;

    public ElementWrapperPlugin() {
        this.ignoring = new ComposedIgnoring(this.logger, new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME), new CustomizedIgnoring(LegacyCustomizations.IGNORED_ELEMENT_NAME));
    }

    public String getOptionName() {
        return "XelementWrapper";
    }

    public String getUsage() {
        return "Generates @XmlElementWrapper annotations.";
    }

    @Override
    protected void postProcessModel(Model model, final MModelInfo<NType, NClass> mmodel, ErrorHandler errorHandler) {
        ArrayList<MClassInfo<NType, NClass>> classInfos = new ArrayList<MClassInfo<NType, NClass>>(mmodel.getClassInfos());
        for (final MClassInfo mClassInfo : classInfos) {
            ArrayList properties = new ArrayList(mClassInfo.getProperties());
            for (MPropertyInfo mPropertyInfo : properties) {
                mPropertyInfo.acceptPropertyInfoVisitor(new DefaultPropertyInfoVisitor<NType, NClass, Void>(){

                    @Override
                    public Void visitElementPropertyInfo(MElementPropertyInfo<NType, NClass> wrapperPropertyInfo) {
                        ElementWrapperPlugin.this.processWrapperElementPropertyInfo(mmodel, mClassInfo, wrapperPropertyInfo);
                        return null;
                    }
                });
            }
        }
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    @Override
    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME, LegacyCustomizations.IGNORED_ELEMENT_NAME);
    }

    protected void processWrapperElementPropertyInfo(final MModelInfo<NType, NClass> mmodel, final MClassInfo<NType, NClass> rootClassInfo, final MElementPropertyInfo<NType, NClass> wrapperPropertyInfo) {
        wrapperPropertyInfo.getTypeInfo().acceptTypeInfoVisitor(new DefaultTypeInfoVisitor<NType, NClass, Void>(){

            @Override
            public Void visitClassInfo(MClassInfo<NType, NClass> wrapperClassInfo) {
                MPropertyInfo<NType, NClass> wrappedPropertyInfo;
                if (wrapperClassInfo.getProperties().size() == 1 && (wrappedPropertyInfo = wrapperClassInfo.getProperties().get(0)).isCollection()) {
                    ElementWrapperPlugin.this.processWrappedPropertyInfo(mmodel, rootClassInfo, wrapperPropertyInfo, wrapperClassInfo, wrappedPropertyInfo);
                }
                return null;
            }
        });
    }

    protected void processWrappedPropertyInfo(final MModelInfo<NType, NClass> mmodel, final MClassInfo<NType, NClass> rootClassInfo, final MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, final MClassInfo<NType, NClass> wrapperClassInfo, MPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        wrappedPropertyInfo.acceptPropertyInfoVisitor(new DefaultPropertyInfoVisitor<NType, NClass, Void>(){

            @Override
            public Void visitElementPropertyInfo(MElementPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementPropertyInfo(mmodel, rootClassInfo, wrapperPropertyInfo, wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }

            @Override
            public Void visitElementsPropertyInfo(MElementsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementsPropertyInfo(mmodel, rootClassInfo, wrapperPropertyInfo, wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }

            @Override
            public Void visitElementRefPropertyInfo(MElementRefPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementRefPropertyInfo(mmodel, rootClassInfo, wrapperPropertyInfo, wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }

            @Override
            public Void visitElementRefsPropertyInfo(MElementRefsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
                ElementWrapperPlugin.this.processWrappedElementRefsPropertyInfo(mmodel, rootClassInfo, wrapperPropertyInfo, wrapperClassInfo, wrappedPropertyInfo);
                return null;
            }
        });
    }

    protected void processWrappedElementPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementPropertyInfo<NType, NClass> propertyInfo = new CMElementPropertyInfo<NType, NClass>(new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), wrappedPropertyInfo.getTypeInfo(), wrappedPropertyInfo.getElementName(), wrapperPropertyInfo.getWrapperElementName(), wrappedPropertyInfo.isNillable(), wrappedPropertyInfo.getDefaultValue(), wrappedPropertyInfo.getDefaultValueNamespaceContext());
        rootClassInfo.addProperty(propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }

    protected void processWrappedElementsPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementsPropertyInfo<NType, NClass> propertyInfo = new CMElementsPropertyInfo<NType, NClass>(new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), wrappedPropertyInfo.getElementTypeInfos(), wrapperPropertyInfo.getElementName());
        rootClassInfo.addProperty(propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }

    protected void processWrappedElementRefPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementRefPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementRefPropertyInfo<NType, NClass> propertyInfo = new CMElementRefPropertyInfo<NType, NClass>(new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), wrappedPropertyInfo.getTypeInfo(), wrappedPropertyInfo.getElementName(), wrapperPropertyInfo.getElementName(), wrappedPropertyInfo.isMixed(), wrappedPropertyInfo.isDomAllowed(), wrappedPropertyInfo.isTypedObjectAllowed(), wrappedPropertyInfo.getDefaultValue(), wrappedPropertyInfo.getDefaultValueNamespaceContext());
        rootClassInfo.addProperty(propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }

    protected void processWrappedElementRefsPropertyInfo(MModelInfo<NType, NClass> mmodel, MClassInfo<NType, NClass> rootClassInfo, MElementPropertyInfo<NType, NClass> wrapperPropertyInfo, MClassInfo<NType, NClass> wrapperClassInfo, MElementRefsPropertyInfo<NType, NClass> wrappedPropertyInfo) {
        System.out.println("Class info:" + rootClassInfo.getName());
        System.out.println("Wrapper property info:" + wrapperPropertyInfo.getPrivateName());
        System.out.println("Wrapper class info :" + wrapperClassInfo.getName());
        System.out.println("Wrapped property info:" + wrappedPropertyInfo.getPrivateName());
        CMElementRefsPropertyInfo<NType, NClass> propertyInfo = new CMElementRefsPropertyInfo<NType, NClass>(new DummyPropertyInfoOrigin(), wrapperClassInfo, wrapperPropertyInfo.getPrivateName(), wrappedPropertyInfo.isCollection(), wrappedPropertyInfo.isRequired(), wrappedPropertyInfo.getElementTypeInfos(), wrapperPropertyInfo.getElementName(), wrappedPropertyInfo.isMixed(), wrappedPropertyInfo.isDomAllowed(), wrappedPropertyInfo.isTypedObjectAllowed());
        rootClassInfo.addProperty(propertyInfo);
        rootClassInfo.removeProperty(wrapperPropertyInfo);
        mmodel.removeClassInfo(wrapperClassInfo);
    }
}

