/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.body;

import japa.parser.ast.DocumentableNode;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.comments.JavadocComment;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.type.Type;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.VoidVisitor;
import java.util.List;

public final class MethodDeclaration
extends BodyDeclaration
implements DocumentableNode {
    private int modifiers;
    private List<TypeParameter> typeParameters;
    private Type type;
    private NameExpr name;
    private List<Parameter> parameters;
    private int arrayCount;
    private List<NameExpr> throws_;
    private BlockStmt body;

    public MethodDeclaration() {
    }

    public MethodDeclaration(int modifiers, Type type, String name) {
        this.setModifiers(modifiers);
        this.setType(type);
        this.setName(name);
    }

    public MethodDeclaration(int modifiers, Type type, String name, List<Parameter> parameters) {
        this.setModifiers(modifiers);
        this.setType(type);
        this.setName(name);
        this.setParameters(parameters);
    }

    public MethodDeclaration(int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<NameExpr> throws_, BlockStmt block) {
        super(annotations);
        this.setModifiers(modifiers);
        this.setTypeParameters(typeParameters);
        this.setType(type);
        this.setName(name);
        this.setParameters(parameters);
        this.setArrayCount(arrayCount);
        this.setThrows(throws_);
        this.setBody(block);
    }

    public MethodDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<NameExpr> throws_, BlockStmt block) {
        super(beginLine, beginColumn, endLine, endColumn, annotations);
        this.setModifiers(modifiers);
        this.setTypeParameters(typeParameters);
        this.setType(type);
        this.setName(name);
        this.setParameters(parameters);
        this.setArrayCount(arrayCount);
        this.setThrows(throws_);
        this.setBody(block);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public BlockStmt getBody() {
        return this.body;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<NameExpr> getThrows() {
        return this.throws_;
    }

    public Type getType() {
        return this.type;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setBody(BlockStmt body) {
        this.body = body;
        this.setAsParentNodeOf(this.body);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = new NameExpr(name);
    }

    public void setNameExpr(NameExpr name) {
        this.name = name;
    }

    @Override
    public void setJavaDoc(JavadocComment javadocComment) {
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.setAsParentNodeOf(this.parameters);
    }

    public void setThrows(List<NameExpr> throws_) {
        this.throws_ = throws_;
        this.setAsParentNodeOf(this.throws_);
    }

    public void setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
    }

    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
    }

    @Override
    public JavadocComment getJavaDoc() {
        return null;
    }
}

