/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.parser.value;

import java.lang.reflect.Array;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.jaxb.annox.model.annotation.value.AbstractBasicXAnnotationValueVisitor;
import org.jvnet.jaxb.annox.model.annotation.value.XAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XArrayClassAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XClassAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XClassByNameAnnotationValue;
import org.jvnet.jaxb.annox.parser.exception.ValueParseException;
import org.jvnet.jaxb.annox.parser.java.visitor.ClassExpressionVisitor;
import org.jvnet.jaxb.annox.parser.java.visitor.ExpressionVisitor;
import org.jvnet.jaxb.annox.parser.value.XAnnotationValueParser;

public class XClassAnnotationValueParser
extends XAnnotationValueParser<Class<?>, Class<?>> {
    @Override
    public XAnnotationValue<Class<?>> parse(String value, Class<?> type) throws ValueParseException {
        try {
            Class _class = ClassUtils.getClass((String)value);
            XClassAnnotationValue annotationValue = new XClassAnnotationValue(_class);
            return annotationValue;
        }
        catch (ClassNotFoundException cnfex) {
            int lastLeftBracketPosition = value.lastIndexOf(91);
            int lastRightBracketPosition = value.lastIndexOf(93);
            if (lastLeftBracketPosition >= 0 && lastRightBracketPosition > lastLeftBracketPosition) {
                String classNamePart = value.substring(0, lastLeftBracketPosition);
                String indexPart = value.substring(lastLeftBracketPosition + 1, lastRightBracketPosition);
                String suffixPart = value.substring(lastRightBracketPosition + 1);
                if (!StringUtils.isBlank((CharSequence)classNamePart) && StringUtils.isBlank((CharSequence)indexPart) && StringUtils.isBlank((CharSequence)suffixPart)) {
                    XAnnotationValue<Class<?>> componentTypeValue = this.parse(classNamePart.trim(), type);
                    return (XAnnotationValue)componentTypeValue.accept(new AbstractBasicXAnnotationValueVisitor<XAnnotationValue<Class<?>>>(){

                        @Override
                        public XAnnotationValue<Class<?>> visitDefault(XAnnotationValue<?> value) {
                            throw new IllegalArgumentException();
                        }

                        @Override
                        public XAnnotationValue<Class<?>> visit(XClassAnnotationValue<?> value) {
                            Class itemClass = (Class)value.getValue();
                            Class<?> arrayClass = Array.newInstance(itemClass, 0).getClass();
                            XClassAnnotationValue classAnnotationValue = new XClassAnnotationValue(arrayClass);
                            return classAnnotationValue;
                        }

                        @Override
                        public XAnnotationValue<Class<?>> visit(XClassByNameAnnotationValue<?> value) {
                            XArrayClassAnnotationValue arrayClassAnnotationValue = new XArrayClassAnnotationValue(value, 1);
                            return arrayClassAnnotationValue;
                        }

                        @Override
                        public XAnnotationValue<Class<?>> visit(XArrayClassAnnotationValue<?, ?> value) {
                            XArrayClassAnnotationValue arrayClassAnnotationValue = new XArrayClassAnnotationValue(value.getItemClassByNameAnnotationValue(), value.getDimension() + 1);
                            return arrayClassAnnotationValue;
                        }
                    });
                }
            }
            XClassByNameAnnotationValue classByNameAnnotationValue = new XClassByNameAnnotationValue(value);
            return classByNameAnnotationValue;
        }
    }

    @Override
    public XAnnotationValue<Class<?>> construct(Class<?> value, Class<?> type) {
        XClassAnnotationValue annotationValue = new XClassAnnotationValue(value);
        return annotationValue;
    }

    @Override
    public ExpressionVisitor<XAnnotationValue<Class<?>>> createExpressionVisitor(Class<?> type) {
        return new ClassExpressionVisitor(type);
    }
}

