/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jvnet.jaxb.annox.model.XAnnotation;
import org.jvnet.jaxb.annox.model.XMember;
import org.jvnet.jaxb.annox.model.XParameter;
import org.jvnet.jaxb.annox.reflect.ParameterizedAnnotatedElement;
import org.jvnet.jaxb.annox.util.Validate;

public class XMethod
extends XMember<Method>
implements ParameterizedAnnotatedElement {
    public static final XMethod[] EMPTY_ARRAY = new XMethod[0];
    private final XParameter[] parameters;

    public XMethod(Method method, XAnnotation<?>[] xannotations, XParameter[] parameters) {
        super(method, xannotations);
        Validate.noNullElements(parameters);
        this.parameters = parameters;
        this.check();
    }

    public XParameter[] getParameters() {
        return this.parameters;
    }

    private void check() {
        Class<?>[] parameterTypes;
        Method method = this.getMethod();
        XParameter[] parameters = this.getParameters();
        Validate.isTrue(parameters.length == (parameterTypes = method.getParameterTypes()).length, "Wrong number of parameters: [" + parameters.length + "], expected [" + parameterTypes.length + "].");
        for (int index = 0; index < parameters.length; ++index) {
            XParameter parameter = parameters[index];
            Class<?> parameterType = parameterTypes[index];
            Validate.isTrue(parameterType.equals(parameter.getType()), "Wrong parameter type: [" + parameter.getType() + "], expected [" + parameterType + "]");
        }
    }

    public Method getMethod() {
        return (Method)this.getMember();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        XParameter[] xparameters = this.getParameters();
        Annotation[][] parameterAnnotations = new Annotation[xparameters.length][];
        for (int index = 0; index < xparameters.length; ++index) {
            parameterAnnotations[index] = xparameters[index].getAnnotations();
        }
        return parameterAnnotations;
    }
}

