/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.jvnet.jaxb.annox.model.XAnnotation;
import org.jvnet.jaxb.annox.model.XMember;
import org.jvnet.jaxb.annox.model.XParameter;
import org.jvnet.jaxb.annox.reflect.ParameterizedAnnotatedElement;
import org.jvnet.jaxb.annox.util.Validate;

public class XConstructor
extends XMember<Constructor<?>>
implements ParameterizedAnnotatedElement {
    public static final XConstructor[] EMPTY_ARRAY = new XConstructor[0];
    private final XParameter[] parameters;

    public XConstructor(Constructor<?> constructor, XAnnotation<?>[] xannotations, XParameter[] parameters) {
        super(constructor, xannotations);
        this.parameters = parameters;
        this.check();
    }

    public XParameter[] getParameters() {
        return this.parameters;
    }

    private void check() {
        Class<?>[] parameterTypes;
        Constructor<?> constructor = this.getConstructor();
        XParameter[] parameters = this.getParameters();
        Validate.isTrue(parameters.length == (parameterTypes = constructor.getParameterTypes()).length, "Wrong number of parameters: [" + parameters.length + "], expected [" + parameterTypes.length + "].");
        for (int index = 0; index < parameters.length; ++index) {
            XParameter parameter = parameters[index];
            Class<?> parameterType = parameterTypes[index];
            Validate.isTrue(parameterType.equals(parameter.getType()), "Wrong parameter type: [" + parameter.getType() + "], expected [" + parameterType + "]");
        }
    }

    public Constructor<?> getConstructor() {
        return (Constructor)this.getMember();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        XParameter[] xparameters = this.getParameters();
        Annotation[][] parameterAnnotations = new Annotation[xparameters.length][];
        for (int index = 0; index < xparameters.length; ++index) {
            parameterAnnotations[index] = xparameters[index].getAnnotations();
        }
        return parameterAnnotations;
    }
}

