/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.util;

import java.util.Collection;
import java.util.Iterator;

public class Validate {
    public static <T> T notNull(T object) {
        return Validate.notNull(object, "The validated object is null");
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static void isTrue(boolean expression) {
        Validate.isTrue(expression, "The validated expression is false");
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection collection) {
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException("The validated collection is empty");
        }
    }

    public static void noNullElements(Collection<?> collection) {
        Validate.noNullElements(collection, null);
    }

    public static void noNullElements(Collection<?> collection, String message) {
        Validate.notNull(collection);
        int i = 0;
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                throw new IllegalArgumentException((message == null ? "" : message) + "The validated collection contains null element at index: " + i);
            }
            ++i;
        }
    }

    public static <T> T[] noNullElements(T[] array) {
        return Validate.noNullElements(array, null);
    }

    public static <T> T[] noNullElements(T[] array, String message) {
        Validate.notNull(array);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException((message == null ? "" : message) + "The validated array contains null element at index: " + i);
        }
        return array;
    }
}

