/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.persistence.util;

import jakarta.xml.ns.persistence.orm.Attributes;
import jakarta.xml.ns.persistence.orm.Basic;
import jakarta.xml.ns.persistence.orm.ElementCollection;
import jakarta.xml.ns.persistence.orm.EmbeddableAttributes;
import jakarta.xml.ns.persistence.orm.Embedded;
import jakarta.xml.ns.persistence.orm.EmbeddedId;
import jakarta.xml.ns.persistence.orm.Id;
import jakarta.xml.ns.persistence.orm.ManyToMany;
import jakarta.xml.ns.persistence.orm.ManyToOne;
import jakarta.xml.ns.persistence.orm.OneToMany;
import jakarta.xml.ns.persistence.orm.OneToOne;
import jakarta.xml.ns.persistence.orm.Transient;
import jakarta.xml.ns.persistence.orm.Version;

public class AttributesUtils {
    private AttributesUtils() {
    }

    public static Object getAttribute(Object attributes, String name) {
        if (attributes == null || name == null) {
            return null;
        }
        if (attributes instanceof Attributes) {
            return AttributesUtils.getAttribute((Attributes)attributes, name);
        }
        if (attributes instanceof EmbeddableAttributes) {
            return AttributesUtils.getAttribute((EmbeddableAttributes)attributes, name);
        }
        throw new IllegalArgumentException("Illegal attributes object class [" + String.valueOf(attributes.getClass()) + "].");
    }

    public static Object getAttribute(Attributes attributes, String name) {
        if (attributes == null || name == null) {
            return null;
        }
        for (Id id : attributes.getId()) {
            if (id == null || !name.equals(id.getName())) continue;
            return id;
        }
        EmbeddedId attribute = attributes.getEmbeddedId();
        if (attribute != null && name.equals(attribute.getName())) {
            return attribute;
        }
        for (Basic basic : attributes.getBasic()) {
            if (basic == null || !name.equals(basic.getName())) continue;
            return basic;
        }
        for (Version version : attributes.getVersion()) {
            if (version == null || !name.equals(version.getName())) continue;
            return version;
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            if (manyToOne == null || !name.equals(manyToOne.getName())) continue;
            return manyToOne;
        }
        for (OneToMany oneToMany : attributes.getOneToMany()) {
            if (oneToMany == null || !name.equals(oneToMany.getName())) continue;
            return oneToMany;
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            if (oneToOne == null || !name.equals(oneToOne.getName())) continue;
            return oneToOne;
        }
        for (ManyToMany manyToMany : attributes.getManyToMany()) {
            if (manyToMany == null || !name.equals(manyToMany.getName())) continue;
            return manyToMany;
        }
        for (ElementCollection elementCollection : attributes.getElementCollection()) {
            if (elementCollection == null || !name.equals(elementCollection.getName())) continue;
            return elementCollection;
        }
        for (Embedded embedded : attributes.getEmbedded()) {
            if (embedded == null || !name.equals(embedded.getName())) continue;
            return embedded;
        }
        for (Transient transient_ : attributes.getTransient()) {
            if (transient_ == null || !name.equals(transient_.getName())) continue;
            return transient_;
        }
        return null;
    }

    public static Object getAttribute(EmbeddableAttributes attributes, String name) {
        if (attributes == null || name == null) {
            return null;
        }
        for (Basic basic : attributes.getBasic()) {
            if (basic == null || !name.equals(basic.getName())) continue;
            return basic;
        }
        for (ManyToOne manyToOne : attributes.getManyToOne()) {
            if (manyToOne == null || !name.equals(manyToOne.getName())) continue;
            return manyToOne;
        }
        for (OneToMany oneToMany : attributes.getOneToMany()) {
            if (oneToMany == null || !name.equals(oneToMany.getName())) continue;
            return oneToMany;
        }
        for (OneToOne oneToOne : attributes.getOneToOne()) {
            if (oneToOne == null || !name.equals(oneToOne.getName())) continue;
            return oneToOne;
        }
        for (ManyToMany manyToMany : attributes.getManyToMany()) {
            if (manyToMany == null || !name.equals(manyToMany.getName())) continue;
            return manyToMany;
        }
        for (ElementCollection elementCollection : attributes.getElementCollection()) {
            if (elementCollection == null || !name.equals(elementCollection.getName())) continue;
            return elementCollection;
        }
        for (Embedded embedded : attributes.getEmbedded()) {
            if (embedded == null || !name.equals(embedded.getName())) continue;
            return embedded;
        }
        for (Transient transient_ : attributes.getTransient()) {
            if (transient_ == null || !name.equals(transient_.getName())) continue;
            return transient_;
        }
        return null;
    }
}

