/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import javax.persistence.EmbeddedId;
import javax.persistence.EntityManager;
import javax.persistence.Id;

public class EntityUtils {
    private EntityUtils() {
    }

    public static Object getId(Object entity) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return EntityUtils.getId(null, entity);
    }

    public static Object getId(EntityManager entityManager, Object entity) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Collection atEmbeddedIdFields = EntityUtils.getAnnotatedElements((AnnotatedElement[])entity.getClass().getFields(), EmbeddedId.class);
        Collection atEmbeddedIdMethods = EntityUtils.getAnnotatedElements((AnnotatedElement[])entity.getClass().getMethods(), EmbeddedId.class);
        Collection atIdFields = EntityUtils.getAnnotatedElements((AnnotatedElement[])entity.getClass().getFields(), Id.class);
        Collection atIdMethods = EntityUtils.getAnnotatedElements((AnnotatedElement[])entity.getClass().getMethods(), Id.class);
        if (atEmbeddedIdFields.size() > 0) {
            assert (atEmbeddedIdFields.size() == 1) : "More than one field is annotated with @EmbeddedId.";
            Field field = (Field)atEmbeddedIdFields.iterator().next();
            return EntityUtils.get(entity, field);
        }
        if (atEmbeddedIdMethods.size() > 0) {
            assert (atEmbeddedIdMethods.size() == 1) : "More than one method is annotated with @EmbeddedId.";
            Method method = (Method)atEmbeddedIdMethods.iterator().next();
            return EntityUtils.get(entity, method);
        }
        if (atIdFields.size() == 1) {
            return EntityUtils.get(entity, (Field)atIdFields.iterator().next());
        }
        if (atIdMethods.size() == 1) {
            return EntityUtils.get(entity, (Method)atIdMethods.iterator().next());
        }
        if (entityManager != null) {
            try {
                return EntityUtils.getIdWithHibernate(entityManager, entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("No id could be found.");
    }

    private static Object getIdWithHibernate(EntityManager entityManager, Object entity) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> hibernateEntityManagerClass = Class.forName("org.hibernate.ejb.AbstractEntityManagerImpl");
        Class<?> hibernateSessionClass = Class.forName("org.hibernate.Session");
        Method getSession = hibernateEntityManagerClass.getMethod("getSession", new Class[0]);
        Method getIdentifier = hibernateSessionClass.getMethod("getIdentifier", Object.class);
        return getIdentifier.invoke(getSession.invoke((Object)entityManager, new Object[0]), entity);
    }

    private static <T extends AnnotatedElement> Collection<T> getAnnotatedElements(T[] elements, Class<? extends Annotation> annotationType) {
        LinkedList<T> annotatedElements = new LinkedList<T>();
        for (T element : elements) {
            if (!element.isAnnotationPresent(annotationType)) continue;
            annotatedElements.add(element);
        }
        return annotatedElements;
    }

    private static Object get(Object target, Field field) throws IllegalArgumentException, IllegalAccessException {
        return field.get(target);
    }

    private static Object get(Object target, Method method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return method.invoke(target, (Object[])null);
    }
}

