/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.test;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Test;
import org.jvnet.hyperjaxb3.ejb.test.AbstractEntityManagerTest;
import org.jvnet.jaxb.test.AbstractSamplesTest;
import org.jvnet.jaxb.xml.bind.ContextPathAware;

public abstract class AbstractEntityManagerSamplesTest
extends AbstractEntityManagerTest
implements ContextPathAware {
    private static final IOFileFilter JAVA_1_5_SAMPLES = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".xml"), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"1.6.xml")));
    private static final IOFileFilter JAVA_1_6_SAMPLES = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".xml"), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"1.5.xml")));
    private static final IOFileFilter SAMPLES = SystemUtils.IS_JAVA_1_5 ? JAVA_1_5_SAMPLES : JAVA_1_6_SAMPLES;
    private AbstractSamplesTest samplesTest;
    public static final String DEFAULT_SAMPLES_DIRECTORY_NAME = "src/test/samples";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.samplesTest = this.createSamplesTest();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected AbstractSamplesTest createSamplesTest() {
        return new AbstractSamplesTest(){

            protected void checkSample(File sample) throws Exception {
                AbstractEntityManagerSamplesTest.this.checkSample(sample);
            }

            protected String getContextPath() {
                return AbstractEntityManagerSamplesTest.this.getContextPath();
            }

            protected Class<? extends Object> getTestClass() {
                return AbstractEntityManagerSamplesTest.this.getClass();
            }

            protected File[] getSampleFiles() {
                return AbstractEntityManagerSamplesTest.this.getSampleFiles();
            }

            protected File getSamplesDirectory() {
                return AbstractEntityManagerSamplesTest.this.getSamplesDirectory();
            }

            protected ClassLoader getContextClassLoader() {
                return AbstractEntityManagerSamplesTest.this.getContextClassLoader();
            }
        };
    }

    @Test
    public void testSamples() throws Exception {
        if (this.samplesTest != null) {
            this.samplesTest.testSamples();
        }
    }

    protected JAXBContext createContext() throws JAXBException {
        return this.samplesTest.createContext();
    }

    @Override
    public String getPersistenceUnitName() {
        return this.getContextPath();
    }

    protected abstract void checkSample(File var1) throws Exception;

    public String getContextPath() {
        return this.getClass().getPackage().getName();
    }

    protected File getBaseDir() {
        try {
            return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile().getParentFile().getAbsoluteFile();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected File getSamplesDirectory() {
        return new File(this.getBaseDir(), this.getSamplesDirectoryName());
    }

    protected File[] getSampleFiles() {
        File samplesDirectory = this.getSamplesDirectory();
        this.logger.debug((Object)("Sample directory [" + samplesDirectory.getAbsolutePath() + "]."));
        if (samplesDirectory == null || !samplesDirectory.isDirectory()) {
            return new File[0];
        }
        Collection files = FileUtils.listFiles((File)samplesDirectory, (IOFileFilter)SAMPLES, (IOFileFilter)TrueFileFilter.INSTANCE);
        return files.toArray(new File[files.size()]);
    }

    protected String getSamplesDirectoryName() {
        return DEFAULT_SAMPLES_DIRECTORY_NAME;
    }

    protected ClassLoader getContextClassLoader() {
        return this.getClass().getClassLoader();
    }
}

