/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.test;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FilenameFilter;
import org.junit.jupiter.api.Test;
import org.jvnet.hyperjaxb3.ejb.test.AbstractEntityManagerTest;
import org.jvnet.jaxb.test.AbstractSamplesTest;
import org.jvnet.jaxb.xml.bind.ContextPathAware;

public abstract class AbstractEntityManagerSamplesTest
extends AbstractEntityManagerTest
implements ContextPathAware {
    private AbstractSamplesTest samplesTest;
    public static final String DEFAULT_SAMPLES_DIRECTORY_NAME = "src/test/samples";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.samplesTest = this.createSamplesTest();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected AbstractSamplesTest createSamplesTest() {
        return new AbstractSamplesTest(){

            protected void checkSample(File sample) throws Exception {
                AbstractEntityManagerSamplesTest.this.checkSample(sample);
            }

            protected String getContextPath() {
                return AbstractEntityManagerSamplesTest.this.getContextPath();
            }

            protected Class<? extends Object> getTestClass() {
                return AbstractEntityManagerSamplesTest.this.getClass();
            }

            protected File[] getSampleFiles() {
                return AbstractEntityManagerSamplesTest.this.getSampleFiles();
            }

            protected File getSamplesDirectory() {
                return AbstractEntityManagerSamplesTest.this.getSamplesDirectory();
            }

            protected ClassLoader getContextClassLoader() {
                return AbstractEntityManagerSamplesTest.this.getContextClassLoader();
            }
        };
    }

    @Test
    public void testSamples() throws Exception {
        if (this.samplesTest != null) {
            this.samplesTest.testSamples();
        }
    }

    protected JAXBContext createContext() throws JAXBException {
        return this.samplesTest.createContext();
    }

    @Override
    public String getPersistenceUnitName() {
        return this.getContextPath();
    }

    protected abstract void checkSample(File var1) throws Exception;

    public String getContextPath() {
        return this.getClass().getPackage().getName();
    }

    protected File getBaseDir() {
        try {
            return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile().getParentFile().getAbsoluteFile();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected File getSamplesDirectory() {
        return new File(this.getBaseDir(), this.getSamplesDirectoryName());
    }

    protected File[] getSampleFiles() {
        File samplesDirectory = this.getSamplesDirectory();
        if (samplesDirectory == null) {
            return new File[0];
        }
        this.logger.debug((Object)("Sample directory [" + samplesDirectory.getAbsolutePath() + "]."));
        if (!samplesDirectory.isDirectory()) {
            return new File[0];
        }
        return samplesDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.endsWith(".xml") && !name.endsWith("1.5.xml");
            }
        });
    }

    protected String getSamplesDirectoryName() {
        return DEFAULT_SAMPLES_DIRECTORY_NAME;
    }

    protected ClassLoader getContextClassLoader() {
        return this.getClass().getClassLoader();
    }
}

