/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEntityManagerTest
extends TestCase {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Class lastTestClass;
    protected EntityManagerFactory entityManagerFactory;

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setUp() throws Exception {
        super.setUp();
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf == null || !emf.isOpen() || this.lastTestClass != ((Object)((Object)this)).getClass()) {
            this.setEntityManagerFactory(this.createEntityManagerFactory());
            this.lastTestClass = ((Object)((Object)this)).getClass();
        }
    }

    public String getPersistenceUnitName() {
        Package _package = ((Object)((Object)this)).getClass().getPackage();
        String name = _package.getName();
        if (name == null) {
            return "root";
        }
        return name;
    }

    public Map getEntityManagerProperties() {
        return null;
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        Map properties;
        try {
            Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/persistence.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                this.logger.debug((Object)("Detected [" + resource + "]."));
            }
        }
        catch (IOException resources) {
            // empty catch block
        }
        if ((properties = this.getEntityManagerFactoryProperties()) == null) {
            return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName());
        }
        return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map getEntityManagerFactoryProperties() {
        try {
            Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.getEntityManagerFactoryPropertiesResourceName());
            if (!resources.hasMoreElements()) {
                this.logger.debug((Object)"Entity manager factory properties are not set.");
                return null;
            }
            this.logger.debug((Object)"Loading entity manager factory properties.");
            Properties properties = new Properties();
            if (!resources.hasMoreElements()) return properties;
            URL resource = resources.nextElement();
            this.logger.debug((Object)("Loading entity manager factory properties from [" + resource + "]."));
            if (resource == null) {
                return null;
            }
            InputStream is = null;
            try {
                is = resource.openStream();
                properties.load(is);
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException ex) {
                Map map = null;
                return map;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ex2) {
            return null;
        }
    }

    public String getEntityManagerFactoryPropertiesResourceName() {
        return "persistence.properties";
    }

    public EntityManager createEntityManager() {
        Map properties = this.getEntityManagerProperties();
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (properties == null) {
            return emf.createEntityManager();
        }
        return emf.createEntityManager(properties);
    }
}

