/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.model.base;

import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.TypeUse;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.strategy.model.CreatePropertyInfos;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ProcessModel;

public abstract class AbstractWrapBuiltin
implements CreatePropertyInfos {
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Collection<CPropertyInfo> process(ProcessModel context, CPropertyInfo propertyInfo) {
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        assert (types.size() == 1);
        assert (types.iterator().next() instanceof CBuiltinLeafInfo);
        CBuiltinLeafInfo originalTypeUse = this.getTypeUse(context, propertyInfo);
        if (propertyInfo.getAdapter() != null) {
            this.logger.debug((Object)"Adapter property info is not wrapped");
            return Collections.emptyList();
        }
        if (originalTypeUse == CBuiltinLeafInfo.DATA_HANDLER) {
            this.logger.error((Object)"Data handler is currently not supported. See issue #88 (http://java.net/jira/browse/HYPERJAXB3-88).");
            return Collections.emptyList();
        }
        if (originalTypeUse == CBuiltinLeafInfo.ANYTYPE) {
            return this.wrapAnyType(context, propertyInfo);
        }
        TypeUse adaptedTypeUse = (TypeUse)context.getAdaptBuiltinTypeUse().process(context, propertyInfo);
        if (adaptedTypeUse == null) {
            this.logger.error((Object)("Unsupported builtin type [" + originalTypeUse.getTypeName() + "] in property [" + propertyInfo.getName(true) + "]."));
            return Collections.emptyList();
        }
        CreatePropertyInfos createPropertyInfos = this.getCreatePropertyInfos(context, propertyInfo);
        Collection<CPropertyInfo> newPropertyInfos = createPropertyInfos.process(context, propertyInfo);
        return newPropertyInfos;
    }

    protected abstract Collection<CPropertyInfo> wrapAnyType(ProcessModel var1, CPropertyInfo var2);

    public abstract CBuiltinLeafInfo getTypeUse(ProcessModel var1, CPropertyInfo var2);

    public abstract CreatePropertyInfos getCreatePropertyInfos(ProcessModel var1, CPropertyInfo var2);
}

