/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.mapping;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.ClassOutline;
import jakarta.persistence.InheritanceType;
import jakarta.xml.ns.persistence.orm.Attributes;
import jakarta.xml.ns.persistence.orm.Entity;
import jakarta.xml.ns.persistence.orm.Inheritance;
import jakarta.xml.ns.persistence.orm.Table;
import javax.xml.namespace.QName;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.ClassOutlineMapping;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.jaxb.util.CustomizationUtils;

public class EntityMapping
implements ClassOutlineMapping<Entity> {
    @Override
    public Entity process(Mapping context, ClassOutline classOutline, Options options) {
        org.jvnet.hyperjaxb3.ejb.schemas.customizations.Entity entity = context.getCustomizing().getEntity(classOutline);
        this.createEntity(context, classOutline, (Entity)entity);
        return entity;
    }

    public void createEntity(Mapping context, ClassOutline classOutline, Entity entity) {
        this.createEntity$Name(context, classOutline, entity);
        this.createEntity$Class(context, classOutline, entity);
        this.createEntity$Inheritance(context, classOutline, entity);
        this.createEntity$Table(context, classOutline, entity);
        this.createEntity$Attributes(context, classOutline, entity);
    }

    public void createEntity$Name(Mapping context, ClassOutline classOutline, Entity entity) {
        if (entity.getName() == null || "##default".equals(entity.getName())) {
            entity.setName(context.getNaming().getEntityName(context, classOutline.parent(), (NType)classOutline.target));
        }
    }

    public void createEntity$Class(Mapping context, ClassOutline classOutline, Entity entity) {
        if (entity.getClazz() == null || "##default".equals(entity.getClazz())) {
            entity.setClazz(context.getNaming().getEntityClass(context, classOutline.parent(), (NType)classOutline.target));
        }
    }

    public void createEntity$Inheritance(Mapping context, ClassOutline classOutline, Entity entity) {
        InheritanceType inheritanceStrategy = this.getInheritanceStrategy(context, classOutline, entity);
        if (this.isRootClass(context, classOutline)) {
            if (entity.getInheritance() == null || entity.getInheritance().getStrategy() == null) {
                entity.setInheritance(new Inheritance());
                entity.getInheritance().setStrategy(inheritanceStrategy.name());
            }
        } else if (entity.getInheritance() != null && entity.getInheritance().getStrategy() != null) {
            entity.setInheritance(null);
        }
    }

    private void createEntity$Table(Mapping context, ClassOutline classOutline, Entity entity) {
        InheritanceType inheritanceStrategy = this.getInheritanceStrategy(context, classOutline, entity);
        switch (inheritanceStrategy) {
            case JOINED: {
                if (entity.getTable() == null) {
                    entity.setTable(new Table());
                }
                this.createTable(context, classOutline, entity.getTable());
                break;
            }
            case SINGLE_TABLE: {
                if (this.isRootClass(context, classOutline)) {
                    if (entity.getTable() == null) {
                        entity.setTable(new Table());
                    }
                    this.createTable(context, classOutline, entity.getTable());
                    break;
                }
                if (entity.getTable() == null) break;
                entity.setTable(null);
                break;
            }
            case TABLE_PER_CLASS: {
                if (entity.getTable() == null) {
                    entity.setTable(new Table());
                }
                this.createTable(context, classOutline, entity.getTable());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown inheritance strategy.");
            }
        }
    }

    public void createTable(Mapping context, ClassOutline classOutline, Table table) {
        if (table.getName() == null || "##default".equals(table.getName())) {
            table.setName(context.getNaming().getEntityTable$Name(context, classOutline));
        }
    }

    public void createEntity$Attributes(Mapping context, ClassOutline classOutline, Entity entity) {
        Attributes attributes = context.getAttributesMapping().process(context, classOutline, null);
        entity.setAttributes(attributes);
    }

    public InheritanceType getInheritanceStrategy(Mapping context, ClassOutline classOutline, Entity entity) {
        if (this.isRootClass(context, classOutline)) {
            if (entity.getInheritance() != null && entity.getInheritance().getStrategy() != null) {
                return InheritanceType.valueOf((String)entity.getInheritance().getStrategy());
            }
            return InheritanceType.JOINED;
        }
        ClassOutline superClassOutline = this.getSuperClass(context, classOutline);
        org.jvnet.hyperjaxb3.ejb.schemas.customizations.Entity superClassEntity = context.getCustomizing().getEntity(superClassOutline);
        return this.getInheritanceStrategy(context, superClassOutline, (Entity)superClassEntity);
    }

    public ClassOutline getSuperClass(Mapping context, ClassOutline classOutline) {
        return classOutline.getSuperClass();
    }

    public boolean isRootClass(Mapping context, ClassOutline classOutline) {
        if (classOutline.getSuperClass() != null) {
            return !CustomizationUtils.containsCustomization((ClassOutline)classOutline, (QName)Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME) && !this.isSelfOrAncestorRootClass(context, classOutline.getSuperClass());
        }
        return !CustomizationUtils.containsCustomization((ClassOutline)classOutline, (QName)Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME);
    }

    public boolean isSelfOrAncestorRootClass(Mapping context, ClassOutline classOutline) {
        if (context.getIgnoring().isClassOutlineIgnored(context, classOutline)) {
            return false;
        }
        if (this.isRootClass(context, classOutline)) {
            return true;
        }
        if (classOutline.getSuperClass() != null) {
            return this.isSelfOrAncestorRootClass(context, classOutline.getSuperClass());
        }
        return !CustomizationUtils.containsCustomization((ClassOutline)classOutline, (QName)Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME);
    }
}

