/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.persistence.Transient;
import jakarta.xml.ns.persistence.orm.Attributes;
import jakarta.xml.ns.persistence.orm.Embeddable;
import jakarta.xml.ns.persistence.orm.EmbeddableAttributes;
import jakarta.xml.ns.persistence.orm.Entity;
import jakarta.xml.ns.persistence.orm.MappedSuperclass;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.plugin.EjbPlugin;
import org.jvnet.hyperjaxb3.ejb.strategy.annotate.Annotator;
import org.jvnet.hyperjaxb3.ejb.strategy.annotate.CreateXAnnotations;
import org.jvnet.hyperjaxb3.ejb.strategy.ignoring.Ignoring;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.hyperjaxb3.ejb.strategy.outline.OutlineProcessor;
import org.jvnet.hyperjaxb3.persistence.util.AttributesUtils;
import org.jvnet.jaxb.annox.model.XAnnotation;
import org.jvnet.jaxb.plugin.util.ArrayUtils;
import org.jvnet.jaxb.util.FieldAccessorUtils;
import org.jvnet.jaxb.util.OutlineUtils;

public class AnnotateOutline
implements OutlineProcessor<EjbPlugin> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Ignoring ignoring;
    private Mapping mapping;
    private CreateXAnnotations createXAnnotations;
    private Annotator applyXAnnotations = new Annotator();

    @Override
    public Collection<ClassOutline> process(EjbPlugin context, Outline outline, Options options) throws Exception {
        this.logger.debug((Object)("Processing outline with context path [" + OutlineUtils.getContextPath((Outline)outline) + "]."));
        Collection classes = outline.getClasses();
        ArrayList<ClassOutline> processedClassOutlines = new ArrayList<ClassOutline>(classes.size());
        for (ClassOutline classOutline : classes) {
            ClassOutline processedClassOutline;
            if (this.getIgnoring().isClassOutlineIgnored(this.getMapping(), classOutline) || (processedClassOutline = this.process(this, classOutline, options)) == null) continue;
            processedClassOutlines.add(processedClassOutline);
        }
        return processedClassOutlines;
    }

    public ClassOutline process(AnnotateOutline context, ClassOutline classOutline, Options options) throws Exception {
        FieldOutline[] fieldOutlines;
        Collection<XAnnotation<?>> annotations;
        Attributes attributes;
        Entity entity;
        this.logger.debug((Object)("Processing class outline [" + OutlineUtils.getClassName((ClassOutline)classOutline) + "]."));
        Object entityOrMappedSuperclassOrEmbeddable = context.getMapping().getEntityOrMappedSuperclassOrEmbeddableMapping().process(context.getMapping(), classOutline, options);
        if (entityOrMappedSuperclassOrEmbeddable instanceof Entity) {
            entity = (Entity)entityOrMappedSuperclassOrEmbeddable;
            attributes = entity.getAttributes() == null ? new Attributes() : entity.getAttributes();
            annotations = context.getCreateXAnnotations().createEntityAnnotations(entity);
        } else if (entityOrMappedSuperclassOrEmbeddable instanceof MappedSuperclass) {
            entity = (MappedSuperclass)entityOrMappedSuperclassOrEmbeddable;
            attributes = entity.getAttributes() == null ? new Attributes() : entity.getAttributes();
            annotations = context.getCreateXAnnotations().createMappedSuperclassAnnotations((MappedSuperclass)entity);
        } else if (entityOrMappedSuperclassOrEmbeddable instanceof Embeddable) {
            Embeddable embeddable = (Embeddable)entityOrMappedSuperclassOrEmbeddable;
            attributes = embeddable.getAttributes() == null ? new EmbeddableAttributes() : embeddable.getAttributes();
            annotations = context.getCreateXAnnotations().createEmbeddableAnnotations(embeddable);
        } else {
            throw new AssertionError((Object)("Either entity or mapped superclass expected, but an instance of [" + String.valueOf(entityOrMappedSuperclassOrEmbeddable.getClass()) + "] received."));
        }
        this.logger.debug((Object)("Annotating the class [" + OutlineUtils.getClassName((ClassOutline)classOutline) + "]:\n" + ArrayUtils.toString(annotations)));
        context.getApplyXAnnotations().annotate(classOutline.ref.owner(), (JAnnotatable)classOutline.ref, annotations);
        if (classOutline.target.declaresAttributeWildcard()) {
            this.processAttributeWildcard(classOutline);
        }
        for (FieldOutline fieldOutline : fieldOutlines = classOutline.getDeclaredFields()) {
            this.process(context, fieldOutline, options, attributes);
        }
        return classOutline;
    }

    private void processAttributeWildcard(ClassOutline classOutline) {
        this.logger.debug((Object)("The class [" + OutlineUtils.getClassName((ClassOutline)classOutline) + "] declares an attribute wildcard which will be made transient."));
        String FIELD_NAME = "otherAttributes";
        String METHOD_SEED = classOutline.parent().getModel().getNameConverter().toClassName(FIELD_NAME);
        JMethod getOtherAttributesMethod = classOutline.ref.getMethod("get" + METHOD_SEED, new JType[0]);
        if (getOtherAttributesMethod == null) {
            this.logger.error((Object)("Could not find the attribute wildcard method in the class [" + OutlineUtils.getClassName((ClassOutline)classOutline) + "]."));
        } else {
            getOtherAttributesMethod.annotate(Transient.class);
        }
    }

    public FieldOutline process(AnnotateOutline context, FieldOutline fieldOutline, Options options, Object attributes) {
        String name = context.getMapping().getNaming().getPropertyName(context.getMapping(), fieldOutline);
        this.logger.debug((Object)("Processing field [" + name + "]."));
        JMethod issetter = FieldAccessorUtils.issetter((FieldOutline)fieldOutline);
        if (issetter != null) {
            this.logger.debug((Object)("Annotating [" + issetter.name() + "] with @javax.persistence.Transient."));
            issetter.annotate(Transient.class);
        }
        Object attribute = AttributesUtils.getAttribute((Object)attributes, (String)name);
        Collection<XAnnotation<?>> xannotations = context.getCreateXAnnotations().createAttributeAnnotations(attribute);
        JMethod getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
        this.logger.debug((Object)("Annotating the field [" + OutlineUtils.getFieldName((FieldOutline)fieldOutline) + "]:\n" + ArrayUtils.toString(xannotations)));
        if (xannotations == null) {
            this.logger.error((Object)("No annotations for the field [" + OutlineUtils.getFieldName((FieldOutline)fieldOutline) + "]:\n" + ArrayUtils.toString(xannotations)));
        } else {
            context.getApplyXAnnotations().annotate(fieldOutline.parent().ref.owner(), (JAnnotatable)getter, xannotations);
        }
        return fieldOutline;
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public CreateXAnnotations getCreateXAnnotations() {
        return this.createXAnnotations;
    }

    public void setCreateXAnnotations(CreateXAnnotations createXAnnotations) {
        this.createXAnnotations = createXAnnotations;
    }

    public Annotator getApplyXAnnotations() {
        return this.applyXAnnotations;
    }

    public void setApplyXAnnotations(Annotator annotator) {
        this.applyXAnnotations = annotator;
    }
}

