/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.customizing.impl;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.xml.xsom.XSComponent;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.ns.persistence.orm.Column;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Basic;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.CollectionProperty;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.ElementCollection;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Embeddable;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Embedded;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.EmbeddedId;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Entity;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.GeneratedClass;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.GeneratedId;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.GeneratedProperty;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.GeneratedVersion;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Id;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.JaxbContext;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.ManyToMany;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.ManyToOne;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.MappedSuperclass;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Mergeable;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.OneToMany;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.OneToOne;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Persistence;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.SingleProperty;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.ToMany;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.ToOne;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Version;
import org.jvnet.hyperjaxb3.ejb.strategy.customizing.Customizing;
import org.jvnet.hyperjaxb3.jaxb.lang.MergeableMergeStrategy;
import org.jvnet.hyperjaxb3.xsom.SimpleTypeAnalyzer;
import org.jvnet.hyperjaxb3.xsom.TypeUtils;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.util.CustomizationUtils;

public class DefaultCustomizing
implements Customizing {
    private static final Log logger = LogFactory.getLog(Customizations.class);
    private final Map<CPluginCustomization, Object> customizationsMap = new IdentityHashMap<CPluginCustomization, Object>();
    private Persistence defaultCustomizations;
    private static final MergeStrategy MERGE_STRATEGY = new MergeableMergeStrategy((MergeStrategy)JAXBMergeStrategy.INSTANCE);

    private <T> T findCustomization(Model model, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization((Model)model, (QName)name);
        T t = this.unmarshalCustomization(customization);
        return t;
    }

    @Override
    public <T> Collection<T> findCustomizations(Model model, QName name) {
        List customizations = CustomizationUtils.findCustomizations((Model)model, (QName)name);
        return this.unmarshalCustomizations(customizations);
    }

    private <T> T findCustomization(CClassInfo classInfo, QName name, T defaultValue, Merge<T> merge) {
        CPluginCustomization customization = CustomizationUtils.findCustomization((CClassInfo)classInfo, (QName)name);
        return this.unmarshalCustomization(customization, defaultValue, merge);
    }

    private <T> Collection<T> findCustomizations(CClassInfo classInfo, QName name) {
        List customizations = CustomizationUtils.findCustomizations((CClassInfo)classInfo, (QName)name);
        return this.unmarshalCustomizations(customizations);
    }

    private <T> T findCustomization(CPropertyInfo propertyInfo, QName name, T defaultValue, Merge<T> merge) {
        CPluginCustomization customization = CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)name);
        T t = this.unmarshalCustomization(customization, defaultValue, merge);
        return t;
    }

    private <T> T findCustomization(CPropertyInfo propertyInfo, QName name) {
        CPluginCustomization customization = CustomizationUtils.findCustomization((CPropertyInfo)propertyInfo, (QName)name);
        T t = this.unmarshalCustomization(customization);
        return t;
    }

    public void addCustomization(CCustomizable customizable, QName name, Object customization) {
        CPluginCustomization pluginCustomization = CustomizationUtils.addCustomization((CCustomizable)customizable, (JAXBContext)Customizations.getContext(), (QName)name, (Object)customization);
        this.customizationsMap.put(pluginCustomization, customization);
    }

    private <T> Collection<T> unmarshalCustomizations(Collection<CPluginCustomization> customizations) throws AssertionError {
        ArrayList<Object> unmarshalledCustomizations = new ArrayList<Object>(customizations.size());
        for (CPluginCustomization customization : customizations) {
            unmarshalledCustomizations.add(this.unmarshalCustomization(customization, null, null));
        }
        return unmarshalledCustomizations;
    }

    private <T> T unmarshalCustomization(CPluginCustomization customization, T defaultValue, Merge<T> merge) throws AssertionError {
        if (customization == null) {
            return null;
        }
        Object value = this.customizationsMap.get(customization);
        if (value != null) {
            return (T)value;
        }
        Object t = CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)customization);
        if (defaultValue != null) {
            Objects.requireNonNull(merge, "merge should not be null.");
            merge.merge(t, defaultValue);
        }
        this.customizationsMap.put(customization, t);
        return (T)t;
    }

    private <T> T unmarshalCustomization(CPluginCustomization customization) throws AssertionError {
        T t = this.unmarshalCustomization(customization, null, null);
        return t;
    }

    public Persistence getDefaultCustomizations() {
        return this.defaultCustomizations;
    }

    public void setDefaultCustomizations(Persistence defaultCustomization) {
        this.defaultCustomizations = defaultCustomization;
    }

    public Persistence getModelCustomization(Model model) {
        Persistence cPersistence = (Persistence)this.findCustomization(model, Customizations.PERSISTENCE_ELEMENT_NAME);
        if (cPersistence == null) {
            return this.getDefaultCustomizations();
        }
        if (!cPersistence.isMerge()) {
            return cPersistence;
        }
        Persistence defaultPersistence = this.getDefaultCustomizations();
        if (cPersistence.getDefaultManyToOne() != null) {
            if (cPersistence.getDefaultManyToOne().getJoinTable() != null) {
                defaultPersistence.getDefaultManyToOne().getJoinColumn().clear();
            } else if (!cPersistence.getDefaultManyToOne().getJoinColumn().isEmpty()) {
                defaultPersistence.getDefaultManyToOne().setJoinTable(null);
            }
        }
        if (cPersistence.getDefaultOneToOne() != null) {
            if (cPersistence.getDefaultOneToOne().getJoinTable() != null) {
                defaultPersistence.getDefaultOneToOne().getJoinColumn().clear();
            } else if (!cPersistence.getDefaultOneToOne().getJoinColumn().isEmpty()) {
                defaultPersistence.getDefaultOneToOne().setJoinTable(null);
            }
        }
        if (cPersistence.getDefaultOneToMany() != null) {
            if (cPersistence.getDefaultOneToMany().getJoinTable() != null) {
                defaultPersistence.getDefaultOneToMany().getJoinColumn().clear();
            } else if (!cPersistence.getDefaultOneToMany().getJoinColumn().isEmpty()) {
                defaultPersistence.getDefaultOneToMany().setJoinTable(null);
            }
        }
        cPersistence.getDefaultSingleProperty().addAll(defaultPersistence.getDefaultSingleProperty());
        cPersistence.getDefaultCollectionProperty().addAll(defaultPersistence.getDefaultCollectionProperty());
        this.mergeFrom(cPersistence, defaultPersistence);
        return cPersistence;
    }

    @Override
    public GeneratedId getGeneratedId(CClassInfo classInfo) {
        Persistence persistence = this.getModelCustomization(classInfo);
        if (persistence.getDefaultGeneratedId() == null) {
            throw new AssertionError((Object)"Default id element is not provided.");
        }
        GeneratedId defaultId = (GeneratedId)persistence.getDefaultGeneratedId().copyTo((Object)new GeneratedId());
        GeneratedId id = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.GENERATED_ID_ELEMENT_NAME) ? this.findCustomization(classInfo, Customizations.GENERATED_ID_ELEMENT_NAME, defaultId, this.merge()) : defaultId;
        return id;
    }

    @Override
    public GeneratedClass getGeneratedClass(CPropertyInfo propertyInfo) {
        GeneratedClass generatedClass = CustomizationUtils.containsCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.GENERATED_CLASS_ELEMENT_NAME) ? (GeneratedClass)this.findCustomization(propertyInfo, Customizations.GENERATED_CLASS_ELEMENT_NAME) : null;
        return generatedClass;
    }

    @Override
    public GeneratedProperty getGeneratedProperty(CPropertyInfo propertyInfo) {
        GeneratedProperty generatedProperty = CustomizationUtils.containsCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.GENERATED_PROPERTY_ELEMENT_NAME) ? (GeneratedProperty)this.findCustomization(propertyInfo, Customizations.GENERATED_PROPERTY_ELEMENT_NAME) : this.getGeneratedProperty((CClassInfo)propertyInfo.parent(), propertyInfo.getName(true));
        return generatedProperty;
    }

    public GeneratedProperty getGeneratedProperty(CClassInfo classInfo, String propertyName) {
        GeneratedProperty generatedProperty = null;
        if (classInfo != null && CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.GENERATED_PROPERTY_ELEMENT_NAME)) {
            Collection generatedProperties = this.findCustomizations(classInfo, Customizations.GENERATED_PROPERTY_ELEMENT_NAME);
            for (GeneratedProperty p : generatedProperties) {
                if (!propertyName.equals(p.getName())) continue;
                generatedProperty = p;
            }
        }
        return generatedProperty;
    }

    @Override
    public Id getId(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultId() == null) {
            throw new AssertionError((Object)"Default id element is not provided.");
        }
        Id defaultId = (Id)persistence.getDefaultId().copyTo((Object)new Id());
        Id id = CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.ID_ELEMENT_NAME) ? this.findCustomization(property, Customizations.ID_ELEMENT_NAME, defaultId, this.merge()) : defaultId;
        return id;
    }

    @Override
    public Id getId(FieldOutline property) {
        return this.getId(property.getPropertyInfo());
    }

    @Override
    public EmbeddedId getEmbeddedId(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultEmbeddedId() == null) {
            throw new AssertionError((Object)"Default embedded id element is not provided.");
        }
        EmbeddedId defaultId = (EmbeddedId)persistence.getDefaultEmbeddedId().copyTo((Object)new EmbeddedId());
        EmbeddedId id = CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.EMBEDDED_ID_ELEMENT_NAME) ? this.findCustomization(property, Customizations.EMBEDDED_ID_ELEMENT_NAME, defaultId, this.merge()) : defaultId;
        return id;
    }

    @Override
    public EmbeddedId getEmbeddedId(FieldOutline property) {
        return this.getEmbeddedId(property.getPropertyInfo());
    }

    @Override
    public Version getVersion(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultVersion() == null) {
            throw new AssertionError((Object)"Default version element is not provided.");
        }
        Version defaultVersion = (Version)persistence.getDefaultVersion().copyTo((Object)new Version());
        Version version = CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.VERSION_ELEMENT_NAME) ? this.findCustomization(property, Customizations.VERSION_ELEMENT_NAME, defaultVersion, this.merge()) : defaultVersion;
        return version;
    }

    @Override
    public Version getVersion(FieldOutline property) {
        return this.getVersion(property.getPropertyInfo());
    }

    @Override
    public GeneratedVersion getGeneratedVersion(CClassInfo classInfo) {
        Persistence persistence = this.getModelCustomization(classInfo);
        if (persistence.getDefaultGeneratedVersion() == null) {
            throw new AssertionError((Object)"Default generated version element is not provided.");
        }
        GeneratedVersion defaultGeneratedVersion = (GeneratedVersion)persistence.getDefaultGeneratedVersion().copyTo((Object)new GeneratedVersion());
        Object generatedVersion = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.GENERATED_VERSION_ELEMENT_NAME) ? this.findCustomization(classInfo, Customizations.GENERATED_VERSION_ELEMENT_NAME, defaultGeneratedVersion, this.merge()) : (defaultGeneratedVersion.isForced() != false ? defaultGeneratedVersion : null);
        return generatedVersion;
    }

    public Basic getDefaultBasic(CPropertyInfo property) throws AssertionError {
        Basic defaultBasic;
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultBasic() == null) {
            throw new AssertionError((Object)"Default basic element is not provided.");
        }
        XSComponent schemaComponent = property.getSchemaComponent();
        if (schemaComponent == null) {
            defaultBasic = (Basic)persistence.getDefaultBasic().copyTo((Object)new Basic());
        } else {
            List<QName> typeNames = TypeUtils.getTypeNames(schemaComponent);
            Basic basic = null;
            Iterator<QName> typeNameIterator = typeNames.iterator();
            while (typeNameIterator.hasNext() && basic == null) {
                QName typeName = typeNameIterator.next();
                SingleProperty singleProperty = this.getDefaultSingleProperty(persistence, typeName);
                if (singleProperty == null) continue;
                if (singleProperty.getBasic() != null) {
                    basic = singleProperty.getBasic();
                    continue;
                }
                logger.warn((Object)("Default single property for type [" + typeName + "] does not define the expected basic mapping."));
            }
            if (basic == null) {
                defaultBasic = (Basic)persistence.getDefaultBasic().copyTo((Object)new Basic());
            } else {
                defaultBasic = (Basic)basic.copyTo((Object)new Basic());
                this.mergeFrom(defaultBasic, (Basic)persistence.getDefaultBasic().copyTo((Object)new Basic()));
            }
        }
        Column column = defaultBasic.getColumn();
        if (column != null) {
            this.assignColumn$LengthPrecisionScale(property, column);
        }
        return defaultBasic;
    }

    private void assignColumn$LengthPrecisionScale(CPropertyInfo property, Column column) {
        Integer defaultPrecision;
        Integer length = this.createColumn$Length(property);
        if (length != null) {
            column.setLength(length);
        }
        Integer precision = this.createColumn$Precision(property);
        Integer scale = this.createColumn$Scale(property);
        if (precision != null && precision != 0) {
            column.setPrecision(precision);
        } else if (scale != null && scale != 0 && (defaultPrecision = column.getPrecision()) != null) {
            Integer defaultScale = column.getScale();
            int integerDigits = defaultPrecision - (defaultScale == null ? 0 : defaultScale);
            column.setPrecision(Integer.valueOf(integerDigits + scale));
            column.setScale(scale);
        }
        if (scale != null && scale != 0) {
            column.setScale(scale);
        }
    }

    public ElementCollection getDefaultElementCollection(CPropertyInfo property) throws AssertionError {
        ElementCollection defaultItem;
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultElementCollection() == null) {
            throw new AssertionError((Object)"Default element collection element is not provided.");
        }
        XSComponent schemaComponent = property.getSchemaComponent();
        if (schemaComponent == null) {
            defaultItem = (ElementCollection)persistence.getDefaultElementCollection().copyTo((Object)new ElementCollection());
        } else {
            List<QName> typeNames = TypeUtils.getTypeNames(schemaComponent);
            ElementCollection item = null;
            Iterator<QName> typeNameIterator = typeNames.iterator();
            while (typeNameIterator.hasNext() && item == null) {
                QName typeName = typeNameIterator.next();
                CollectionProperty collectionProperty = this.getDefaultCollectionProperty(persistence, typeName);
                if (collectionProperty == null) continue;
                if (collectionProperty.getElementCollection() != null) {
                    item = collectionProperty.getElementCollection();
                    continue;
                }
                logger.warn((Object)("Default single property for type [" + typeName + "] does not define the expected basic mapping."));
            }
            if (item == null) {
                defaultItem = (ElementCollection)persistence.getDefaultElementCollection().copyTo((Object)new ElementCollection());
            } else {
                defaultItem = (ElementCollection)item.copyTo((Object)new ElementCollection());
                this.mergeFrom(defaultItem, (ElementCollection)persistence.getDefaultElementCollection().copyTo((Object)new ElementCollection()));
            }
        }
        if (defaultItem.getColumn() != null) {
            this.assignColumn$LengthPrecisionScale(property, defaultItem.getColumn());
        }
        return defaultItem;
    }

    public SingleProperty getDefaultSingleProperty(Persistence persistence, QName typeName) {
        Objects.requireNonNull(persistence, "Persistence must not be null.");
        Objects.requireNonNull(typeName, "Type name must not be null.");
        for (SingleProperty property : persistence.getDefaultSingleProperty()) {
            if (!typeName.equals(property.getType())) continue;
            return property;
        }
        return null;
    }

    public CollectionProperty getDefaultCollectionProperty(Persistence persistence, QName typeName) {
        Objects.requireNonNull(persistence, "Persistence must not be null.");
        Objects.requireNonNull(typeName, "Type name must not be null.");
        for (CollectionProperty property : persistence.getDefaultCollectionProperty()) {
            if (!typeName.equals(property.getType())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Basic getBasic(CPropertyInfo property) {
        Basic defaultBasic = this.getDefaultBasic(property);
        Basic basic = CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.BASIC_ELEMENT_NAME) ? this.findCustomization(property, Customizations.BASIC_ELEMENT_NAME, defaultBasic, this.merge()) : defaultBasic;
        return basic;
    }

    public Integer createColumn$Scale(CPropertyInfo property) {
        Long fractionDigits = SimpleTypeAnalyzer.getFractionDigits(property.getSchemaComponent());
        Long totalDigits = SimpleTypeAnalyzer.getTotalDigits(property.getSchemaComponent());
        Integer scale = fractionDigits != null ? Integer.valueOf(fractionDigits.intValue()) : (totalDigits != null ? Integer.valueOf(totalDigits.intValue()) : null);
        return scale;
    }

    public Integer createColumn$Precision(CPropertyInfo property) {
        Long totalDigits = SimpleTypeAnalyzer.getTotalDigits(property.getSchemaComponent());
        Long fractionDigits = SimpleTypeAnalyzer.getFractionDigits(property.getSchemaComponent());
        Integer precision = totalDigits != null ? (fractionDigits != null ? Integer.valueOf(totalDigits.intValue() + fractionDigits.intValue()) : Integer.valueOf(totalDigits.intValue() * 2)) : null;
        return precision;
    }

    public Integer createColumn$Length(CPropertyInfo property) {
        int intMinLength;
        Long minLength;
        Long maxLength;
        Long length = SimpleTypeAnalyzer.getLength(property.getSchemaComponent());
        Integer finalLength = length != null ? Integer.valueOf(length.intValue()) : ((maxLength = SimpleTypeAnalyzer.getMaxLength(property.getSchemaComponent())) != null ? Integer.valueOf(maxLength.intValue()) : ((minLength = SimpleTypeAnalyzer.getMinLength(property.getSchemaComponent())) != null ? ((intMinLength = minLength.intValue()) > 127 ? Integer.valueOf(intMinLength * 2) : null) : null));
        return finalLength;
    }

    @Override
    public Basic getBasic(FieldOutline fieldOutline) {
        return this.getBasic(fieldOutline.getPropertyInfo());
    }

    @Override
    public OneToMany getOneToMany(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultOneToMany() == null) {
            throw new AssertionError((Object)"Default one-to-many element is not provided.");
        }
        OneToMany defaultOneToMany = (OneToMany)persistence.getDefaultOneToMany().copyTo((Object)new OneToMany());
        if (!CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.ONE_TO_MANY_ELEMENT_NAME)) {
            return defaultOneToMany;
        }
        OneToMany coneToMany = this.findCustomization(property, Customizations.ONE_TO_MANY_ELEMENT_NAME, defaultOneToMany, new Merge<OneToMany>(){

            @Override
            public void merge(OneToMany value, OneToMany defaultValue) {
                DefaultCustomizing.this.merge(value, defaultValue);
            }
        });
        return coneToMany;
    }

    private void merge(OneToMany cOneToMany, OneToMany defaultOneToMany) {
        if (cOneToMany.isMerge()) {
            if (cOneToMany.getJoinTable() != null) {
                defaultOneToMany.getJoinColumn().clear();
            } else if (!cOneToMany.getJoinColumn().isEmpty()) {
                defaultOneToMany.setJoinTable(null);
            }
            if (cOneToMany.getOrderBy() != null) {
                defaultOneToMany.setOrderColumn(null);
            } else if (cOneToMany.getOrderColumn() != null) {
                defaultOneToMany.setOrderBy(null);
            }
            this.mergeFrom(cOneToMany, defaultOneToMany);
        }
    }

    private void merge(Embedded cEmbedded, Embedded defaultEmbedded) {
        this.mergeFrom(cEmbedded, defaultEmbedded);
    }

    public Persistence getModelCustomization(CPropertyInfo property) {
        CClassInfo classInfo = (CClassInfo)property.parent();
        return this.getModelCustomization(classInfo);
    }

    public Persistence getModelCustomization(CClassInfo classInfo) {
        Persistence persistence = this.getModelCustomization(classInfo.model);
        return persistence;
    }

    @Override
    public OneToMany getOneToMany(FieldOutline property) {
        return this.getOneToMany(property.getPropertyInfo());
    }

    @Override
    public ManyToOne getManyToOne(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultManyToOne() == null) {
            throw new AssertionError((Object)"Default many-to-one element is not provided.");
        }
        ManyToOne defaultManyToOne = (ManyToOne)persistence.getDefaultManyToOne().copyTo((Object)new ManyToOne());
        if (!CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.MANY_TO_ONE_ELEMENT_NAME)) {
            return defaultManyToOne;
        }
        ManyToOne cmanyToOne = this.findCustomization(property, Customizations.MANY_TO_ONE_ELEMENT_NAME, defaultManyToOne, new Merge<ManyToOne>(){

            @Override
            public void merge(ManyToOne value, ManyToOne defaultValue) {
                DefaultCustomizing.this.merge(value, defaultValue);
            }
        });
        return cmanyToOne;
    }

    private void merge(ManyToOne cManyToOne, ManyToOne defaultManyToOne) {
        if (cManyToOne.isMerge()) {
            if (cManyToOne.getJoinTable() != null) {
                defaultManyToOne.getJoinColumn().clear();
            } else if (!cManyToOne.getJoinColumn().isEmpty()) {
                defaultManyToOne.setJoinTable(null);
            }
            this.mergeFrom(cManyToOne, defaultManyToOne);
        }
    }

    @Override
    public ManyToOne getManyToOne(FieldOutline property) {
        return this.getManyToOne(property.getPropertyInfo());
    }

    @Override
    public OneToOne getOneToOne(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultOneToOne() == null) {
            throw new AssertionError((Object)"Default one-to-one element is not provided.");
        }
        OneToOne defaultOneToOne = (OneToOne)persistence.getDefaultOneToOne().copyTo((Object)new OneToOne());
        if (!CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.ONE_TO_ONE_ELEMENT_NAME)) {
            return defaultOneToOne;
        }
        OneToOne cOneToOne = this.findCustomization(property, Customizations.ONE_TO_ONE_ELEMENT_NAME, defaultOneToOne, new Merge<OneToOne>(){

            @Override
            public void merge(OneToOne value, OneToOne defaultValue) {
                DefaultCustomizing.this.merge(value, defaultValue);
            }
        });
        return cOneToOne;
    }

    private void merge(OneToOne cOneToOne, OneToOne defaultOneToOne) {
        if (cOneToOne.isMerge()) {
            if (cOneToOne.getJoinTable() != null) {
                defaultOneToOne.getJoinColumn().clear();
            } else if (!cOneToOne.getJoinColumn().isEmpty()) {
                defaultOneToOne.setJoinTable(null);
            }
            this.mergeFrom(cOneToOne, defaultOneToOne);
        }
    }

    @Override
    public OneToOne getOneToOne(FieldOutline property) {
        return this.getOneToOne(property.getPropertyInfo());
    }

    @Override
    public ManyToMany getManyToMany(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultManyToMany() == null) {
            throw new AssertionError((Object)"Default many-to-many element is not provided.");
        }
        ManyToMany defaultManyToMany = (ManyToMany)persistence.getDefaultManyToMany().copyTo((Object)new ManyToMany());
        if (!CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.MANY_TO_MANY_ELEMENT_NAME)) {
            return defaultManyToMany;
        }
        ManyToMany cManyToMany = this.findCustomization(property, Customizations.MANY_TO_MANY_ELEMENT_NAME, defaultManyToMany, new Merge<ManyToMany>(){

            @Override
            public void merge(ManyToMany value, ManyToMany defaultValue) {
                DefaultCustomizing.this.merge(value, defaultValue);
            }
        });
        return cManyToMany;
    }

    private void merge(ManyToMany source, ManyToMany defaultSource) {
        if (source.isMerge()) {
            if (source.getOrderBy() != null) {
                defaultSource.setOrderColumn(null);
            } else if (source.getOrderColumn() != null) {
                defaultSource.setOrderBy(null);
            }
            this.mergeFrom(source, defaultSource);
        }
    }

    @Override
    public ElementCollection getElementCollection(FieldOutline fieldOutline) {
        return this.getElementCollection(fieldOutline.getPropertyInfo());
    }

    @Override
    public ElementCollection getElementCollection(CPropertyInfo property) {
        ElementCollection defaultItem = this.getDefaultElementCollection(property);
        ElementCollection item = CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.ELEMENT_COLLECTION_ELEMENT_NAME) ? this.findCustomization(property, Customizations.ELEMENT_COLLECTION_ELEMENT_NAME, defaultItem, this.merge()) : defaultItem;
        return item;
    }

    @Override
    public ManyToMany getManyToMany(FieldOutline property) {
        return this.getManyToMany(property.getPropertyInfo());
    }

    @Override
    public Entity getEntity(ClassOutline classOutline) {
        return this.getEntity(classOutline.target);
    }

    public Entity getEntity(CClassInfo classInfo) {
        Persistence persistence = this.getModelCustomization(classInfo);
        if (persistence.getDefaultEntity() == null) {
            throw new AssertionError((Object)"Default entity element is not provided.");
        }
        Entity defaultEntity = (Entity)persistence.getDefaultEntity().copyTo((Object)new Entity());
        if (!CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.ENTITY_ELEMENT_NAME)) {
            this.addCustomization((CCustomizable)classInfo, Customizations.ENTITY_ELEMENT_NAME, defaultEntity);
            return defaultEntity;
        }
        Entity cEntity = this.findCustomization(classInfo, Customizations.ENTITY_ELEMENT_NAME, defaultEntity, this.merge());
        return cEntity;
    }

    @Override
    public Object getToMany(FieldOutline property) {
        return this.getToMany(property.getPropertyInfo());
    }

    @Override
    public Object getToOne(FieldOutline property) {
        return this.getToOne(property.getPropertyInfo());
    }

    @Override
    public Object getToOne(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.MANY_TO_ONE_ELEMENT_NAME)) {
            return this.getManyToOne(property);
        }
        if (CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.ONE_TO_ONE_ELEMENT_NAME)) {
            return this.getOneToOne(property);
        }
        if (CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.EMBEDDED_ELEMENT_NAME)) {
            return this.getEmbedded(property);
        }
        ToOne defaultToOne = (ToOne)persistence.getDefaultToOne().copyTo((Object)new ToOne());
        if (defaultToOne.getOneToOne() != null) {
            OneToOne cOneToOne = defaultToOne.getOneToOne();
            OneToOne defaultOneToOne = persistence.getDefaultOneToOne();
            if (defaultOneToOne == null) {
                throw new AssertionError((Object)"Default One-to-one element is not provided.");
            }
            this.merge(cOneToOne, defaultOneToOne);
            return cOneToOne;
        }
        if (defaultToOne.getManyToOne() != null) {
            ManyToOne cManyToOne = defaultToOne.getManyToOne();
            ManyToOne defaultManyToOne = persistence.getDefaultManyToOne();
            if (defaultManyToOne == null) {
                throw new AssertionError((Object)"Default many-to-one element is not provided.");
            }
            this.merge(cManyToOne, defaultManyToOne);
            return cManyToOne;
        }
        if (defaultToOne.getEmbedded() != null) {
            Embedded cEmbedded = defaultToOne.getEmbedded();
            Embedded defaultEmbedded = persistence.getDefaultEmbedded();
            if (defaultEmbedded == null) {
                throw new AssertionError((Object)"Default embedded element is not provided.");
            }
            this.merge(cEmbedded, defaultEmbedded);
            return cEmbedded;
        }
        throw new AssertionError((Object)"Either one-to-one or many-to-one elements must be provided in the default-to-one element.");
    }

    @Override
    public Object getToMany(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.MANY_TO_MANY_ELEMENT_NAME)) {
            return this.getManyToMany(property);
        }
        if (CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.ONE_TO_MANY_ELEMENT_NAME)) {
            return this.getOneToMany(property);
        }
        ToMany defaultToMany = (ToMany)persistence.getDefaultToMany().copyTo((Object)new ToMany());
        if (defaultToMany.getOneToMany() != null) {
            OneToMany cOneToMany = defaultToMany.getOneToMany();
            OneToMany defaultOneToMany = persistence.getDefaultOneToMany();
            if (defaultOneToMany == null) {
                throw new AssertionError((Object)"Default one-to-many element is not provided.");
            }
            this.merge(cOneToMany, defaultOneToMany);
            return cOneToMany;
        }
        if (defaultToMany.getManyToMany() != null) {
            ManyToMany cManyToMany = defaultToMany.getManyToMany();
            ManyToMany defaultManyToMany = persistence.getDefaultManyToMany();
            if (defaultManyToMany == null) {
                throw new AssertionError((Object)"Default many-to-many element is not provided.");
            }
            this.merge(cManyToMany, defaultManyToMany);
            return cManyToMany;
        }
        throw new AssertionError((Object)"Either one-to-many or many-to-many elements must be provided in the default-to-many element.");
    }

    @Override
    public MappedSuperclass getMappedSuperclass(ClassOutline classOutline) {
        return this.getMappedSuperclass(classOutline.target);
    }

    public MappedSuperclass getMappedSuperclass(CClassInfo classInfo) {
        Persistence persistence = this.getModelCustomization(classInfo);
        if (persistence.getDefaultMappedSuperclass() == null) {
            throw new AssertionError((Object)"Default mapped superclass element is not provided.");
        }
        MappedSuperclass defaultMappedSuperclass = (MappedSuperclass)persistence.getDefaultMappedSuperclass().copyTo((Object)new MappedSuperclass());
        if (!CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME)) {
            return defaultMappedSuperclass;
        }
        MappedSuperclass cMappedSuperclass = this.findCustomization(classInfo, Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME, defaultMappedSuperclass, this.merge());
        return cMappedSuperclass;
    }

    @Override
    public Object getEntityOrMappedSuperclassOrEmbeddable(ClassOutline classOutline) {
        return this.getEntityOrMappedSuperclassOrEmbeddable(classOutline.target);
    }

    @Override
    public Object getEntityOrMappedSuperclassOrEmbeddable(CClassInfo classInfo) {
        if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.ENTITY_ELEMENT_NAME)) {
            return this.getEntity(classInfo);
        }
        if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.MAPPED_SUPERCLASS_ELEMENT_NAME)) {
            return this.getMappedSuperclass(classInfo);
        }
        if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.EMBEDDABLE_ELEMENT_NAME)) {
            return this.getEmbeddable(classInfo);
        }
        return this.getEntity(classInfo);
    }

    public Embeddable getEmbeddable(CClassInfo classInfo) {
        Persistence persistence = this.getModelCustomization(classInfo);
        if (persistence.getDefaultEmbeddable() == null) {
            throw new AssertionError((Object)"Default embeddable element is not provided.");
        }
        Embeddable defaultEmbeddable = (Embeddable)persistence.getDefaultEmbeddable().copyTo((Object)new Embeddable());
        if (!CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.EMBEDDABLE_ELEMENT_NAME)) {
            return defaultEmbeddable;
        }
        Embeddable cEmbeddable = this.findCustomization(classInfo, Customizations.EMBEDDABLE_ELEMENT_NAME, defaultEmbeddable, this.merge());
        return cEmbeddable;
    }

    @Override
    public Embeddable getEmbeddable(ClassOutline classOutline) {
        return this.getEmbeddable(classOutline.target);
    }

    @Override
    public Embedded getEmbedded(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultEmbedded() == null) {
            throw new AssertionError((Object)"Default embedded element is not provided.");
        }
        Embedded defaultEmbedded = (Embedded)persistence.getDefaultEmbedded().copyTo((Object)new Embedded());
        Embedded embedded = CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.EMBEDDED_ELEMENT_NAME) ? this.findCustomization(property, Customizations.EMBEDDED_ELEMENT_NAME, defaultEmbedded, this.merge()) : defaultEmbedded;
        return embedded;
    }

    @Override
    public Embedded getEmbedded(FieldOutline property) {
        return this.getEmbedded(property.getPropertyInfo());
    }

    @Override
    public JaxbContext getJaxbContext(FieldOutline property) {
        return this.getJaxbContext(property.getPropertyInfo());
    }

    @Override
    public JaxbContext getJaxbContext(CPropertyInfo property) {
        Persistence persistence = this.getModelCustomization(property);
        if (persistence.getDefaultJaxbContext() == null) {
            throw new AssertionError((Object)"Default jaxb-context element is not provided.");
        }
        JaxbContext defaultJaxbContext = (JaxbContext)persistence.getDefaultJaxbContext().copyTo((Object)new JaxbContext());
        JaxbContext jaxbContext = CustomizationUtils.containsCustomization((CPropertyInfo)property, (QName)Customizations.JAXB_CONTEXT_ELEMENT_NAME) ? this.findCustomization(property, Customizations.JAXB_CONTEXT_ELEMENT_NAME, defaultJaxbContext, this.merge()) : defaultJaxbContext;
        return jaxbContext;
    }

    private <T extends Mergeable & MergeFrom> void mergeFrom(T value, T defaultValue) {
        ((MergeFrom)value).mergeFrom(null, null, value, defaultValue, MERGE_STRATEGY);
    }

    private <M extends Mergeable & MergeFrom> Merge<M> merge() {
        return new Merge<M>(){

            @Override
            public void merge(M value, M defaultValue) {
                DefaultCustomizing.this.mergeFrom(value, defaultValue);
            }
        };
    }

    private static interface Merge<M> {
        public void merge(M var1, M var2);
    }
}

