/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.naming.impl;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.CClass;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassRef;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.xml.bind.api.impl.NameConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.strategy.ignoring.Ignoring;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.hyperjaxb3.ejb.strategy.naming.Naming;
import org.jvnet.hyperjaxb3.ejb.strategy.naming.impl.EmbeddedNamingWrapper;
import org.jvnet.jaxb2_commons.util.CodeModelUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class DefaultNaming
implements Naming,
InitializingBean {
    private Pattern camelCasePattern = Pattern.compile("\\p{Lower}\\p{Upper}|\\D\\d");
    private Ignoring ignoring;
    protected Log logger = LogFactory.getLog(Naming.class);
    private int maxIdentifierLength = 30;
    private Properties reservedNames;
    private boolean updated = false;
    private Map<String, String> nameKeyMap = new TreeMap<String, String>();
    private Map<String, String> keyNameMap = new TreeMap<String, String>();
    private Map<String, String> forwardTableNamesMap = Collections.synchronizedMap(new HashMap());
    private Map<String, String> reverseTableNamesMap = Collections.synchronizedMap(new HashMap());

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public int getMaxIdentifierLength() {
        return this.maxIdentifierLength;
    }

    public void setMaxIdentifierLength(int maxIdentifierLength) {
        this.maxIdentifierLength = maxIdentifierLength;
    }

    public Properties getReservedNames() {
        return this.reservedNames;
    }

    @Required
    public void setReservedNames(Properties reservedNames) {
        this.reservedNames = reservedNames;
    }

    public void afterPropertiesSet() throws Exception {
        Set<Map.Entry<Object, Object>> entries = this.getReservedNames().entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object entryKey = entry.getKey();
            if (entryKey == null) continue;
            String key = entryKey.toString().toUpperCase();
            Object entryValue = entry.getValue();
            String value = entryValue == null || "".equals(entryValue.toString().trim()) ? key + "_" : entryValue.toString();
            this.nameKeyMap.put(key, value);
            this.keyNameMap.put(value, key);
        }
    }

    @Override
    public String getName(Mapping context, String draftName) {
        Validate.notNull((Object)draftName, (String)"Name must not be null.", (Object[])new Object[0]);
        String intermediateName = draftName.replace('$', '_');
        Matcher camelCaseMatcher = this.camelCasePattern.matcher(intermediateName);
        while (camelCaseMatcher.find()) {
            String regFusion = camelCaseMatcher.group(0);
            intermediateName = intermediateName.replace(regFusion, regFusion.charAt(0) + "_" + regFusion.charAt(1));
        }
        String name = intermediateName.toUpperCase();
        if (this.nameKeyMap.containsKey(name)) {
            return this.nameKeyMap.get(name);
        }
        if (name.length() >= this.getMaxIdentifierLength()) {
            int i = 0;
            while (true) {
                String suffix = Integer.toString(i);
                String prefix = name.substring(0, this.getMaxIdentifierLength() - suffix.length() - 1);
                String identifier = prefix + "_" + suffix;
                if (!this.keyNameMap.containsKey(identifier)) {
                    this.nameKeyMap.put(name, identifier);
                    this.keyNameMap.put(identifier, name);
                    this.updated = true;
                    return identifier;
                }
                ++i;
            }
        }
        if (this.getReservedNames().containsKey(name.toUpperCase())) {
            return name + "_";
        }
        return name;
    }

    @Override
    public String getColumn$Name(Mapping context, FieldOutline fieldOutline) {
        String fieldName = fieldOutline.getPropertyInfo().getName(true);
        return this.getName(context, context.getNaming().getColumn$Name$Prefix(context) + fieldName);
    }

    @Override
    public String getOrderColumn$Name(Mapping context, FieldOutline fieldOutline) {
        String fieldColumnName = this.getColumn$Name(context, fieldOutline);
        return this.getName(context, fieldColumnName + "_HJORDER");
    }

    @Override
    public String getJoinTable$Name(Mapping context, FieldOutline fieldOutline) {
        String targetEntityTableName = this.getTargetEntityTable$Name(context, fieldOutline);
        String entityTableName = this.getEntityTable$Name(context, fieldOutline.parent());
        String fieldColumnName = this.getColumn$Name(context, fieldOutline);
        return this.getName(context, entityTableName + "_" + fieldColumnName + "_" + targetEntityTableName);
    }

    @Override
    public String getEntityTable$Name(Mapping context, FieldOutline fieldOutline) {
        return this.getEntityTable$Name(context, fieldOutline.parent());
    }

    @Override
    public String getEntityTable$Name(Mapping context, ClassOutline classOutline) {
        return this.getEntityTableName(context, (CClass)classOutline.target);
    }

    public String getTableName(String qualifiedName) {
        if (this.forwardTableNamesMap.containsKey(qualifiedName)) {
            return this.forwardTableNamesMap.get(qualifiedName);
        }
        String shortName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        if (!this.reverseTableNamesMap.containsKey(shortName)) {
            this.forwardTableNamesMap.put(qualifiedName, shortName);
            this.reverseTableNamesMap.put(shortName, qualifiedName);
            return shortName;
        }
        for (int index = 0; index < Integer.MAX_VALUE; ++index) {
            String name = shortName + "_" + index;
            if (this.reverseTableNamesMap.containsKey(name)) continue;
            this.forwardTableNamesMap.put(qualifiedName, name);
            this.reverseTableNamesMap.put(name, qualifiedName);
            return name;
        }
        throw new AssertionError((Object)("Could not create a table name for the qualified name [" + qualifiedName + "]"));
    }

    public String getEntityTableName(Mapping context, CClass classInfo) {
        if (classInfo instanceof CClassInfo) {
            return this.getName(context, this.getTableName(((CClassInfo)classInfo).fullName()));
        }
        if (classInfo instanceof CClassRef) {
            String fullName = ((CClassRef)classInfo).fullName();
            return this.getName(context, this.getTableName(fullName));
        }
        throw new AssertionError((Object)"Unexpected type.");
    }

    private String getTargetEntityTable$Name(Mapping context, FieldOutline fieldOutline) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        assert (types.size() == 1);
        CTypeInfo type = (CTypeInfo)types.iterator().next();
        assert (type instanceof CClass);
        CClass childClassInfo = (CClass)type;
        return this.getEntityTableName(context, childClassInfo);
    }

    @Override
    public String getJoinColumn$Name(Mapping context, FieldOutline fieldOutline, FieldOutline idFieldOutline) {
        String entityTableName = this.getEntityTable$Name(context, fieldOutline.parent());
        String fieldColumnName = this.getName(context, fieldOutline.getPropertyInfo().getName(true));
        String idFieldColumnName = this.getName(context, idFieldOutline.getPropertyInfo().getName(true));
        return this.getName(context, context.getNaming().getColumn$Name$Prefix(context) + fieldColumnName + "_" + entityTableName + "_" + idFieldColumnName);
    }

    @Override
    public String getJoinTable$JoinColumn$Name(Mapping context, FieldOutline fieldOutline, FieldOutline idFieldOutline) {
        String entityTableName = this.getEntityTable$Name(context, fieldOutline.parent());
        String idFieldColumnName = this.getColumn$Name(context, idFieldOutline);
        return this.getName(context, "PARENT_" + entityTableName + "_" + idFieldColumnName);
    }

    @Override
    public String getJoinTable$InverseJoinColumn$Name(Mapping context, FieldOutline fieldOutline, FieldOutline idFieldOutline) {
        String idFieldColumnName = this.getColumn$Name(context, idFieldOutline);
        return this.getName(context, "CHILD_" + this.getTargetEntityTable$Name(context, fieldOutline) + "_" + idFieldColumnName);
    }

    @Override
    public String getPersistenceUnitName(Mapping context, Outline outline) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (PackageOutline packageOutline : outline.getAllPackageContexts()) {
            if (this.getIgnoring().isPackageOutlineIgnored(context, outline, packageOutline)) continue;
            if (!first) {
                sb.append(':');
            } else {
                first = false;
            }
            String packageName = packageOutline._package().name();
            sb.append(packageName);
        }
        return sb.toString();
    }

    @Override
    public String getEntityName(Mapping context, Outline outline, NType type) {
        JType theType = type.toType(outline, Aspect.EXPOSED);
        assert (theType instanceof JClass);
        JClass theClass = (JClass)theType;
        return CodeModelUtils.getLocalClassName((JClass)theClass);
    }

    @Override
    public String getEntityClass(Mapping context, Outline outline, NType type) {
        JType theType = type.toType(outline, Aspect.EXPOSED);
        assert (theType instanceof JClass);
        JClass theClass = (JClass)theType;
        return CodeModelUtils.getPackagedClassName((JClass)theClass);
    }

    @Override
    public String getPropertyName(Mapping context, FieldOutline fieldOutline) {
        return NameConverter.standard.toVariableName(fieldOutline.getPropertyInfo().getName(true));
    }

    @Override
    public Naming createEmbeddedNaming(Mapping context, FieldOutline fieldOutline) {
        return new EmbeddedNamingWrapper(this, fieldOutline);
    }

    @Override
    public String getColumn$Name$Prefix(Mapping context) {
        return "";
    }

    @Override
    public String getElementCollection$CollectionTable$Name(Mapping context, FieldOutline fieldOutline) {
        String entityTableName = this.getEntityTable$Name(context, fieldOutline.parent());
        String fieldColumnName = this.getColumn$Name(context, fieldOutline);
        return this.getName(context, entityTableName + "_" + fieldColumnName);
    }

    @Override
    public String getElementCollection$CollectionTable$JoinColumn$Name(Mapping context, FieldOutline fieldOutline, FieldOutline idFieldOutline) {
        String idFieldColumnName = this.getName(context, idFieldOutline.getPropertyInfo().getName(true));
        return this.getName(context, context.getNaming().getColumn$Name$Prefix(context) + idFieldColumnName);
    }

    @Override
    public String getElementCollection$OrderColumn$Name(Mapping context, FieldOutline fieldOutline) {
        String columnName = context.getNaming().getColumn$Name$Prefix(context) + "HJINDEX";
        return this.getName(context, columnName);
    }

    @Override
    public String getElementCollection$Column$Name(Mapping context, FieldOutline fieldOutline) {
        String columnName = context.getNaming().getColumn$Name$Prefix(context) + "HJVALUE";
        return this.getName(context, columnName);
    }
}

