/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.ignoring.impl;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassInfoParent;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.IgnoredPackage;
import org.jvnet.hyperjaxb3.ejb.strategy.customizing.Customizing;
import org.jvnet.hyperjaxb3.ejb.strategy.ignoring.Ignoring;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ProcessModel;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;

public class DefaultIgnoring
implements Ignoring {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Customizing customizing;

    public Customizing getCustomizing() {
        return this.customizing;
    }

    public void setCustomizing(Customizing customizing) {
        this.customizing = customizing;
    }

    @Override
    public boolean isPackageOutlineIgnored(Mapping context, Outline outline, PackageOutline packageOutline) {
        for (IgnoredPackage ignoredPackage : this.getCustomizing().findCustomizations(outline.getModel(), Customizations.IGNORED_PACKAGE_ELEMENT_NAME)) {
            if (!packageOutline._package().name().equals(ignoredPackage.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClassOutlineIgnored(Mapping context, ClassOutline classOutline) {
        if (this.isPackageOutlineIgnored(context, classOutline.parent(), classOutline._package())) {
            this.logger.debug((Object)"Class outline is ignored since package is ignored.");
            this.markAsAcknowledged(classOutline);
            return true;
        }
        if (CustomizationUtils.containsCustomization((ClassOutline)classOutline, (QName)Customizations.IGNORED_ELEMENT_NAME)) {
            this.logger.debug((Object)"Class outline is ignored per customization.");
            this.markAsAcknowledged(classOutline);
            return true;
        }
        if (classOutline.getSuperClass() != null && this.isClassOutlineIgnored(context, classOutline.getSuperClass())) {
            this.logger.debug((Object)"Class outline is ignored since superclass outline is ignored.");
            this.markAsAcknowledged(classOutline);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFieldOutlineIgnored(Mapping context, FieldOutline fieldOutline) {
        if (this.isClassOutlineIgnored(context, fieldOutline.parent())) {
            this.logger.debug((Object)"Field outline is ignored since its class outline is ignored.");
            return true;
        }
        if (CustomizationUtils.containsCustomization((FieldOutline)fieldOutline, (QName)Customizations.IGNORED_ELEMENT_NAME)) {
            this.logger.debug((Object)"Field outline is ignored per customization.");
            return true;
        }
        boolean allIgnored = true;
        Collection types = (Collection)context.getGetTypes().process(context, fieldOutline.getPropertyInfo());
        for (CTypeInfo type : types) {
            if (type instanceof CClassInfo) {
                CClassInfo fieldClassInfo = (CClassInfo)type;
                ClassOutline fieldClassOutline = fieldOutline.parent().parent().getClazz(fieldClassInfo);
                allIgnored = allIgnored && this.isClassOutlineIgnored(context, fieldClassOutline);
                continue;
            }
            allIgnored = false;
        }
        if (allIgnored) {
            this.logger.debug((Object)"Field outline is ignored since all types are ignored.");
            this.markAsAcknowledged(fieldOutline);
        }
        return allIgnored;
    }

    public void markAsAcknowledged(FieldOutline fieldOutline) {
        Customizations.markAsAcknowledged((CPropertyInfo)fieldOutline.getPropertyInfo());
    }

    public void markAsAcknowledged(ClassOutline classOutline) {
        Customizations.markAsAcknowledged((CClassInfo)classOutline.target);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            Customizations.markAsAcknowledged((CPropertyInfo)fieldOutline.getPropertyInfo());
        }
    }

    @Override
    public boolean isPackageInfoIgnored(ProcessModel context, Model model, CClassInfoParent.Package packageInfo) {
        for (IgnoredPackage ignoredPackage : this.getCustomizing().findCustomizations(model, Customizations.IGNORED_PACKAGE_ELEMENT_NAME)) {
            if (!packageInfo.pkg.name().equals(ignoredPackage.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClassInfoIgnored(ProcessModel context, CClassInfo classInfo) {
        if (this.isPackageInfoIgnored(context, classInfo.model, this.getPackageInfo((CClassInfoParent)classInfo))) {
            this.logger.debug((Object)"Class info is ignored since package is ignored.");
            this.markAsAcknowledged(classInfo);
            return true;
        }
        if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.IGNORED_ELEMENT_NAME)) {
            this.logger.debug((Object)"Class info is ignored per customization.");
            this.markAsAcknowledged(classInfo);
            return true;
        }
        if (classInfo.getBaseClass() != null && this.isClassInfoIgnored(context, classInfo.getBaseClass())) {
            this.logger.debug((Object)"Class info is ignored since base class info is ignored.");
            this.markAsAcknowledged(classInfo);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPropertyInfoIgnored(ProcessModel context, CPropertyInfo propertyInfo) {
        if (propertyInfo.parent() instanceof CClassInfo && this.isClassInfoIgnored(context, (CClassInfo)propertyInfo.parent())) {
            this.logger.debug((Object)"Property info is ignored since its class info is ignored.");
            return true;
        }
        if (CustomizationUtils.containsCustomization((CPropertyInfo)propertyInfo, (QName)Customizations.IGNORED_ELEMENT_NAME)) {
            this.logger.debug((Object)"Property info is ignored per customization.");
            return true;
        }
        boolean allIgnored = true;
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        for (CTypeInfo type : types) {
            if (type instanceof CClassInfo) {
                CClassInfo fieldClassInfo = (CClassInfo)type;
                allIgnored = allIgnored && this.isClassInfoIgnored(context, fieldClassInfo);
                continue;
            }
            allIgnored = false;
        }
        if (allIgnored) {
            this.logger.debug((Object)"Property info is ignored since all types are ignored.");
            this.markAsAcknowledged(propertyInfo);
        }
        return allIgnored;
    }

    private CClassInfoParent.Package getPackageInfo(CClassInfoParent parent) {
        if (parent instanceof CClassInfoParent.Package) {
            return (CClassInfoParent.Package)parent;
        }
        if (parent instanceof CClassInfo) {
            return this.getPackageInfo(((CClassInfo)parent).parent());
        }
        if (parent instanceof CElementInfo) {
            return this.getPackageInfo(((CElementInfo)parent).parent);
        }
        throw new AssertionError((Object)("Unexpexted class info parent [" + parent + "]."));
    }

    public void markAsAcknowledged(CClassInfo classInfo) {
        Customizations.markAsAcknowledged((CClassInfo)classInfo);
    }

    public void markAsAcknowledged(CPropertyInfo propertyInfo) {
        Customizations.markAsAcknowledged((CPropertyInfo)propertyInfo);
    }
}

