/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.InitializationException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamConverters;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamImplicitCollection;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.annotations.XStreamSerializeAs;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.DependencyInjectionFactory;
import com.thoughtworks.xstream.mapper.AnnotationConfiguration;
import com.thoughtworks.xstream.mapper.AttributeMapper;
import com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import com.thoughtworks.xstream.mapper.LocalConversionMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMapper
extends MapperWrapper
implements AnnotationConfiguration {
    private boolean locked;
    private final Object[] arguments;
    private final ConverterRegistry converterRegistry;
    private final ClassAliasingMapper classAliasingMapper;
    private final DefaultImplementationsMapper defaultImplementationsMapper;
    private final ImplicitCollectionMapper implicitCollectionMapper;
    private final FieldAliasingMapper fieldAliasingMapper;
    private final AttributeMapper attributeMapper;
    private final LocalConversionMapper localConversionMapper;
    private final Map<Class<?>, Map<List<Object>, Converter>> converterCache = new HashMap();
    private final Set<Class<?>> annotatedTypes = new HashSet();
    private final Map<Class<?>, Boolean> processedTypes = new ConcurrentHashMap();
    private final Map<Class, String> serializedClass = new ConcurrentHashMap<Class, String>();

    public AnnotationMapper(Mapper wrapped, ConverterRegistry converterRegistry, ConverterLookup converterLookup, ClassLoader classLoader, ReflectionProvider reflectionProvider, JVM jvm) {
        super(wrapped);
        this.converterRegistry = converterRegistry;
        this.annotatedTypes.add(Object.class);
        this.classAliasingMapper = (ClassAliasingMapper)this.lookupMapperOfType(ClassAliasingMapper.class);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.lookupMapperOfType(DefaultImplementationsMapper.class);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.lookupMapperOfType(ImplicitCollectionMapper.class);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.lookupMapperOfType(FieldAliasingMapper.class);
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        this.localConversionMapper = (LocalConversionMapper)this.lookupMapperOfType(LocalConversionMapper.class);
        this.locked = true;
        this.arguments = new Object[]{this, classLoader, reflectionProvider, jvm, converterLookup};
    }

    @Override
    public String realMember(Class type, String serialized) {
        if (!this.locked) {
            this.processAnnotations(type);
        }
        return super.realMember(type, serialized);
    }

    @Override
    public String serializedClass(Class type) {
        String name;
        if (!this.locked) {
            this.processAnnotations(type);
        }
        if (type != null && (name = this.serializedClass.get(type)) != null) {
            return name;
        }
        return super.serializedClass(type);
    }

    @Override
    public Class defaultImplementationOf(Class type) {
        if (!this.locked) {
            this.processAnnotations(type);
        }
        Class defaultImplementation = super.defaultImplementationOf(type);
        if (!this.locked) {
            this.processAnnotations(defaultImplementation);
        }
        return defaultImplementation;
    }

    @Override
    public Converter getLocalConverter(Class definedIn, String fieldName) {
        if (!this.locked) {
            this.processAnnotations(definedIn);
        }
        return super.getLocalConverter(definedIn, fieldName);
    }

    @Override
    public void autodetectAnnotations(boolean mode) {
        this.locked = !mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAnnotations(Class[] initialTypes) {
        if (initialTypes == null || initialTypes.length == 0) {
            return;
        }
        this.locked = true;
        Set<Class<?>> set = this.annotatedTypes;
        synchronized (set) {
            UnprocessedTypesSet types = new UnprocessedTypesSet();
            for (Class initialType : initialTypes) {
                types.add(initialType);
            }
            this.processTypes(types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAnnotations(Class initialType) {
        if (initialType == null) {
            return;
        }
        if (this.processedTypes.containsKey(initialType)) {
            return;
        }
        Set<Class<?>> set = this.annotatedTypes;
        synchronized (set) {
            UnprocessedTypesSet types = new UnprocessedTypesSet();
            if (types.add(initialType)) {
                this.processTypes(types);
            } else {
                this.processedTypes.put(initialType, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTypes(Set<Class<?>> types) {
        while (!types.isEmpty()) {
            Iterator<Class<?>> iter = types.iterator();
            Class<?> type = iter.next();
            iter.remove();
            if (!this.annotatedTypes.add(type)) continue;
            try {
                if (type.isPrimitive()) continue;
                XStreamSerializeAs a = type.getAnnotation(XStreamSerializeAs.class);
                if (a != null && a.value() != Void.TYPE) {
                    this.serializedClass.put(type, a.value().getName());
                }
                this.addParametrizedTypes(type, types);
                this.processConverterAnnotations(type);
                this.processAliasAnnotation(type, types);
                if (type.isInterface()) continue;
                this.processImplicitCollectionAnnotation(type);
                Field[] fields = type.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.isEnumConstant() || (field.getModifiers() & 0x88) > 0) continue;
                    this.addParametrizedTypes(field.getGenericType(), types);
                    if (field.isSynthetic()) continue;
                    this.processFieldAliasAnnotation(field);
                    this.processAsAttributeAnnotation(field);
                    this.processImplicitAnnotation(field);
                    this.processOmitFieldAnnotation(field);
                    this.processLocalConverterAnnotation(field);
                }
            }
            finally {
                this.processedTypes.put(type, true);
            }
        }
    }

    private void addParametrizedTypes(Type type, final Set<Class<?>> types) {
        final HashSet<Type> processedTypes = new HashSet<Type>();
        LinkedHashSet<Type> localTypes = new LinkedHashSet<Type>(){

            @Override
            public boolean add(Type o) {
                if (o instanceof Class) {
                    return types.add((Class)o);
                }
                return o == null || processedTypes.contains(o) ? false : super.add(o);
            }
        };
        while (type != null) {
            processedTypes.add(type);
            if (type instanceof Class) {
                Class clazz = (Class)type;
                types.add(clazz);
                if (!clazz.isPrimitive()) {
                    TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
                    for (Type type2 : typeParameters) {
                        localTypes.add(type2);
                    }
                    localTypes.add(clazz.getGenericSuperclass());
                    for (Type type3 : clazz.getGenericInterfaces()) {
                        localTypes.add(type3);
                    }
                }
            } else if (type instanceof TypeVariable) {
                Type[] bounds;
                TypeVariable typeVariable = (TypeVariable)type;
                for (Type type4 : bounds = typeVariable.getBounds()) {
                    localTypes.add(type4);
                }
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parametrizedType = (ParameterizedType)type;
                localTypes.add(parametrizedType.getRawType());
                Type[] actualArguments = parametrizedType.getActualTypeArguments();
                for (Type type5 : actualArguments) {
                    localTypes.add(type5);
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                localTypes.add(arrayType.getGenericComponentType());
            }
            if (!localTypes.isEmpty()) {
                Iterator iter = localTypes.iterator();
                type = (Type)iter.next();
                iter.remove();
                continue;
            }
            type = null;
        }
    }

    private void processConverterAnnotations(Class<?> type) {
        if (this.converterRegistry != null) {
            ArrayList<XStreamConverter> annotations;
            XStreamConverters convertersAnnotation = type.getAnnotation(XStreamConverters.class);
            XStreamConverter converterAnnotation = type.getAnnotation(XStreamConverter.class);
            ArrayList<XStreamConverter> arrayList = annotations = convertersAnnotation != null ? new ArrayList<XStreamConverter>(Arrays.asList(convertersAnnotation.value())) : new ArrayList();
            if (converterAnnotation != null) {
                annotations.add(converterAnnotation);
            }
            for (XStreamConverter annotation : annotations) {
                Converter converter = this.cacheConverter(annotation, converterAnnotation != null ? type : null);
                if (converter == null) continue;
                if (converterAnnotation != null || converter.canConvert(type)) {
                    this.converterRegistry.registerConverter(converter, annotation.priority());
                    continue;
                }
                throw new InitializationException("Converter " + annotation.value().getName() + " cannot handle annotated class " + type.getName());
            }
        }
    }

    private void processAliasAnnotation(Class<?> type, Set<Class<?>> types) {
        XStreamAlias aliasAnnotation = type.getAnnotation(XStreamAlias.class);
        if (aliasAnnotation != null) {
            if (this.classAliasingMapper == null) {
                throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
            }
            if (aliasAnnotation.impl() != Void.class) {
                this.classAliasingMapper.addClassAlias(aliasAnnotation.value(), type);
                this.defaultImplementationsMapper.addDefaultImplementation(aliasAnnotation.impl(), type);
                if (type.isInterface()) {
                    types.add(aliasAnnotation.impl());
                }
            } else {
                this.classAliasingMapper.addClassAlias(aliasAnnotation.value(), type);
            }
        }
    }

    @Deprecated
    private void processImplicitCollectionAnnotation(Class<?> type) {
        XStreamImplicitCollection implicitColAnnotation = type.getAnnotation(XStreamImplicitCollection.class);
        if (implicitColAnnotation != null) {
            Field field;
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String fieldName = implicitColAnnotation.value();
            String itemFieldName = implicitColAnnotation.item();
            try {
                field = type.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new InitializationException(type.getName() + " does not have a field named '" + fieldName + "' as required by " + XStreamImplicitCollection.class.getName());
            }
            Class<?> itemType = null;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type typeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                itemType = this.getClass(typeArgument);
            }
            if (itemType == null) {
                this.implicitCollectionMapper.add(type, fieldName, null, Object.class);
            } else if (itemFieldName.equals("")) {
                this.implicitCollectionMapper.add(type, fieldName, null, itemType);
            } else {
                this.implicitCollectionMapper.add(type, fieldName, itemFieldName, itemType);
            }
        }
    }

    private void processFieldAliasAnnotation(Field field) {
        XStreamAlias aliasAnnotation = field.getAnnotation(XStreamAlias.class);
        if (aliasAnnotation != null) {
            if (this.fieldAliasingMapper == null) {
                throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
            }
            this.fieldAliasingMapper.addFieldAlias(aliasAnnotation.value(), field.getDeclaringClass(), field.getName());
        }
    }

    private void processAsAttributeAnnotation(Field field) {
        XStreamAsAttribute asAttributeAnnotation = field.getAnnotation(XStreamAsAttribute.class);
        if (asAttributeAnnotation != null) {
            if (this.attributeMapper == null) {
                throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
            }
            this.attributeMapper.addAttributeFor(field);
        }
    }

    private void processImplicitAnnotation(Field field) {
        XStreamImplicit implicitAnnotation = field.getAnnotation(XStreamImplicit.class);
        if (implicitAnnotation != null) {
            Type genericType;
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String fieldName = field.getName();
            String itemFieldName = implicitAnnotation.itemFieldName();
            String keyFieldName = implicitAnnotation.keyFieldName();
            boolean isMap = Map.class.isAssignableFrom(field.getType());
            Class<?> itemType = null;
            if (!field.getType().isArray() && (genericType = field.getGenericType()) instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
                Type typeArgument = actualTypeArguments[isMap ? 1 : 0];
                itemType = this.getClass(typeArgument);
            }
            if (isMap) {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemFieldName != null && !"".equals(itemFieldName) ? itemFieldName : null, itemType, keyFieldName != null && !"".equals(keyFieldName) ? keyFieldName : null);
            } else if (itemFieldName != null && !"".equals(itemFieldName)) {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemFieldName, itemType);
            } else {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemType);
            }
        }
    }

    private void processOmitFieldAnnotation(Field field) {
        XStreamOmitField omitFieldAnnotation = field.getAnnotation(XStreamOmitField.class);
        if (omitFieldAnnotation != null) {
            if (this.fieldAliasingMapper == null) {
                throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
            }
            this.fieldAliasingMapper.omitField(field.getDeclaringClass(), field.getName());
        }
    }

    private void processLocalConverterAnnotation(Field field) {
        Converter converter;
        XStreamConverter annotation = field.getAnnotation(XStreamConverter.class);
        if (annotation != null && (converter = this.cacheConverter(annotation, field.getType())) != null) {
            if (this.localConversionMapper == null) {
                throw new InitializationException("No " + LocalConversionMapper.class.getName() + " available");
            }
            this.localConversionMapper.registerLocalConverter(field.getDeclaringClass(), field.getName(), converter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Converter cacheConverter(XStreamConverter annotation, Class targetType) {
        Converter result = null;
        ArrayList<Object> parameter = new ArrayList<Object>();
        if (targetType != null) {
            parameter.add(targetType);
        }
        ArrayList<Object[]> arrays = new ArrayList<Object[]>();
        arrays.add(annotation.booleans());
        arrays.add(annotation.bytes());
        arrays.add(annotation.chars());
        arrays.add(annotation.doubles());
        arrays.add(annotation.floats());
        arrays.add(annotation.ints());
        arrays.add(annotation.longs());
        arrays.add(annotation.shorts());
        arrays.add(annotation.strings());
        arrays.add(annotation.types());
        for (Object e : arrays) {
            if (e == null) continue;
            int length = Array.getLength(e);
            for (int i = 0; i < length; ++i) {
                Object object = Array.get(e, i);
                if (parameter.contains(object)) continue;
                parameter.add(object);
            }
        }
        Class<? extends ConverterMatcher> converterType = annotation.value();
        Map<List<Object>, Converter> map = this.converterCache.get(converterType);
        if (map != null) {
            result = map.get(parameter);
        }
        if (result == null) {
            void var8_10;
            Converter converter;
            Object[] args;
            int size = parameter.size();
            if (size > 0) {
                args = new Object[this.arguments.length + size];
                System.arraycopy(this.arguments, 0, args, size, this.arguments.length);
                System.arraycopy(parameter.toArray(new Object[size]), 0, args, 0, size);
            } else {
                args = this.arguments;
            }
            try {
                if (SingleValueConverter.class.isAssignableFrom(converterType) && !Converter.class.isAssignableFrom(converterType)) {
                    SingleValueConverter svc = (SingleValueConverter)DependencyInjectionFactory.newInstance(converterType, args);
                    converter = new SingleValueConverterWrapper(svc);
                } else {
                    converter = (Converter)DependencyInjectionFactory.newInstance(converterType, args);
                }
            }
            catch (Exception e) {
                throw new InitializationException("Cannot instantiate converter " + converterType.getName() + (targetType != null ? " for type " + targetType.getName() : ""), e);
            }
            if (map == null) {
                HashMap hashMap = new HashMap();
                this.converterCache.put(converterType, hashMap);
            }
            var8_10.put(parameter, converter);
            result = converter;
        }
        return result;
    }

    private Class<?> getClass(Type typeArgument) {
        Class type = null;
        if (typeArgument instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)typeArgument).getRawType();
        } else if (typeArgument instanceof Class) {
            type = (Class)typeArgument;
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnprocessedTypesSet
    extends LinkedHashSet<Class<?>> {
        private UnprocessedTypesSet() {
        }

        @Override
        public boolean add(Class<?> type) {
            Class<?>[] incTypes;
            XStreamInclude inc;
            boolean ret;
            if (type == null) {
                return false;
            }
            while (type.isArray()) {
                type = type.getComponentType();
            }
            String name = type.getName();
            if (name.startsWith("java.") || name.startsWith("javax.")) {
                return false;
            }
            boolean bl = ret = AnnotationMapper.this.annotatedTypes.contains(type) ? false : super.add(type);
            if (ret && (inc = type.getAnnotation(XStreamInclude.class)) != null && (incTypes = inc.value()) != null) {
                for (Class<?> incType : incTypes) {
                    this.add(incType);
                }
            }
            return ret;
        }
    }
}

