/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CachingMapper
extends MapperWrapper {
    private transient Map realClassCache;

    public CachingMapper(Mapper wrapped) {
        super(wrapped);
        this.readResolve();
    }

    public CachingMapper(ClassMapper wrapped) {
        this((Mapper)wrapped);
        this.readResolve();
    }

    public Class realClass(String elementName) {
        WeakReference reference = (WeakReference)this.realClassCache.get(elementName);
        if (reference != null) {
            Object cached = reference.get();
            if (cached instanceof CannotResolveClassException) {
                throw (CannotResolveClassException)cached;
            }
            if (cached != null) {
                return (Class)cached;
            }
        }
        try {
            Class result = super.realClass(elementName);
            this.realClassCache.put(elementName, new WeakReference<Class>(result));
            return result;
        }
        catch (CannotResolveClassException e) {
            this.realClassCache.put(elementName, new WeakReference<CannotResolveClassException>(e));
            throw e;
        }
    }

    private Object readResolve() {
        this.realClassCache = new ConcurrentHashMap();
        return this;
    }
}

