/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SerializationMethodInvoker {
    private Map cache = new ConcurrentHashMap();
    private static final Object NO_METHOD = new Object();
    private static final Object[] EMPTY_ARGS = new Object[0];

    public Object callReadResolve(Object result) {
        if (result == null) {
            return null;
        }
        Method readResolveMethod = this.getMethod(result.getClass(), "readResolve", null, true);
        if (readResolveMethod != null) {
            try {
                return readResolveMethod.invoke(result, EMPTY_ARGS);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not call " + result.getClass().getName() + ".readResolve()", e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectAccessException("Could not call " + result.getClass().getName() + ".readResolve()", e.getTargetException());
            }
        }
        return result;
    }

    public Object callWriteReplace(Object object) {
        if (object == null) {
            return null;
        }
        Method writeReplaceMethod = this.getMethod(object.getClass(), "writeReplace", null, true);
        if (writeReplaceMethod != null) {
            try {
                Object[] EMPTY_ARGS = new Object[]{};
                return writeReplaceMethod.invoke(object, EMPTY_ARGS);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not call " + object.getClass().getName() + ".writeReplace()", e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectAccessException("Could not call " + object.getClass().getName() + ".writeReplace()", e.getTargetException());
            }
        }
        return object;
    }

    public boolean supportsReadObject(Class type, boolean includeBaseClasses) {
        return this.getMethod(type, "readObject", new Class[]{ObjectInputStream.class}, includeBaseClasses) != null;
    }

    public void callReadObject(Class type, Object object, ObjectInputStream stream) {
        try {
            Method readObjectMethod = this.getMethod(type, "readObject", new Class[]{ObjectInputStream.class}, false);
            readObjectMethod.invoke(object, stream);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Could not call " + object.getClass().getName() + ".readObject()", e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException("Could not call " + object.getClass().getName() + ".readObject()", e.getTargetException());
        }
    }

    public boolean supportsWriteObject(Class type, boolean includeBaseClasses) {
        return this.getMethod(type, "writeObject", new Class[]{ObjectOutputStream.class}, includeBaseClasses) != null;
    }

    public void callWriteObject(Class type, Object instance, ObjectOutputStream stream) {
        try {
            Method readObjectMethod = this.getMethod(type, "writeObject", new Class[]{ObjectOutputStream.class}, false);
            readObjectMethod.invoke(instance, stream);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Could not call " + instance.getClass().getName() + ".writeObject()", e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException("Could not call " + instance.getClass().getName() + ".writeObject()", e.getTargetException());
        }
    }

    private Method getMethod(Class type, String name, Class[] parameterTypes, boolean includeBaseclasses) {
        String typeName = type.getName();
        StringBuffer sb = new StringBuffer(typeName.length() + name.length() + 7);
        sb.append(typeName).append('.').append(name).append('.').append(includeBaseclasses).toString();
        String key = sb.toString();
        Object resultOb = this.cache.get(key);
        if (resultOb != null) {
            return resultOb == NO_METHOD ? null : (Method)resultOb;
        }
        if (includeBaseclasses) {
            while (type != null) {
                try {
                    Method result = type.getDeclaredMethod(name, parameterTypes);
                    result.setAccessible(true);
                    this.cache.put(key, result);
                    return result;
                }
                catch (NoSuchMethodException e) {
                    type = type.getSuperclass();
                }
            }
            this.cache.put(key, NO_METHOD);
            return null;
        }
        try {
            Method result = type.getDeclaredMethod(name, parameterTypes);
            result.setAccessible(true);
            this.cache.put(key, result);
            return result;
        }
        catch (NoSuchMethodException e) {
            this.cache.put(key, NO_METHOD);
            return null;
        }
    }
}

