/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.deploy.weblogic.util;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.util.StringUtils;
import org.hudsonci.plugins.deploy.weblogic.exception.RequiredJDKNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkUtils {
    public static final String JAVA_HOME_PROPERTY = "JAVA_HOME";
    public static final String JAVA_SPECIFICATION_VERSION_15 = "1.5";
    public static final String JAVA_VERSION_COMMAND_VERSION_LINE_REGEX = "^(java version )(\")(.+)(\")(.*\\r*\\n*)$";

    public static boolean isJDK15(JDK jdk, PrintStream logger) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamTaskListener listener = new StreamTaskListener((OutputStream)out);
            Launcher launcher = Hudson.getInstance().createLauncher((TaskListener)listener);
            String cmd = jdk != null ? jdk.getExecutable().getAbsolutePath() : "java";
            int result = launcher.launch().cmds(new String[]{cmd, "-version"}).stdout((OutputStream)out).join();
            if (result != 0) {
                return false;
            }
            if (jdk == null) {
                return JAVA_SPECIFICATION_VERSION_15.equalsIgnoreCase(System.getProperty("java.specification.version"));
            }
            return JdkUtils.extractAndCheckJavaVersion(out.toString(), JAVA_SPECIFICATION_VERSION_15);
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (IllegalStateException ise) {
            return false;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return false;
        }
    }

    public static boolean extractAndCheckJavaVersion(String out, String javaSpecificationVersion) {
        boolean jdk15found = false;
        Vector lines = StringUtils.lineSplit((String)out.toString());
        Iterator it = lines.iterator();
        Pattern pattern = Pattern.compile(JAVA_VERSION_COMMAND_VERSION_LINE_REGEX);
        while (it.hasNext()) {
            String line = (String)it.next();
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches() || !matcher.group(3).startsWith(javaSpecificationVersion)) continue;
            jdk15found = true;
        }
        return jdk15found;
    }

    public static JDK getRequiredJDK(AbstractBuild<?, ?> build, BuildListener listener) throws RequiredJDKNotFoundException {
        JDK out = null;
        if (JdkUtils.isJDK15(null, listener.getLogger())) {
            return null;
        }
        JDK recenltyProjectJdkUsed = build.getProject().getJDK();
        if (JdkUtils.isJDK15(recenltyProjectJdkUsed, listener.getLogger())) {
            return recenltyProjectJdkUsed;
        }
        listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - plugin requires Java 1.5, but this plugin is using " + System.getProperty("java.home") + ". Try to find an appropriate one...");
        List jdksList = Hudson.getInstance().getJDKs();
        for (JDK jdk : jdksList) {
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - jdks : NAME " + jdk.getName() + " HOME " + jdk.getHome());
            if (!JdkUtils.isJDK15(jdk, listener.getLogger())) continue;
            out = jdk;
        }
        if (out == null) {
            throw new RequiredJDKNotFoundException();
        }
        return out;
    }
}

