/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
@Extension
public class XlcCompilerParser
extends RegexpLineParser {
    private static final long serialVersionUID = 5490211629355204910L;
    private static final String XLC_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*.*((?:[A-Z]+|[0-9]+-)[0-9]+)* ?\\([USEWI]\\)\\s*(.*)$";
    private static final String XLC_WARNING_PATTERN_WITH_LINE = "^(?:.*\\[.*\\])?\\s*\"?([^\"]*)\"?, line ([0-9]+)\\.[0-9]+:( (?:[A-Z]+|[0-9]+-)[0-9]+)? \\(([USEWI])\\)\\s*(.*)$";
    private static final String XLC_WARNING_PATTERN_NO_LINE = "^(?:.*\\[.*\\])?\\s*\\s*((?:[A-Z]+|[0-9]+-)[0-9]+)?:? ?\\(([USEWI])\\)( INFORMATION:)?\\s*(.*)$";
    private static final Pattern PATTERN_1 = Pattern.compile("^(?:.*\\[.*\\])?\\s*\"?([^\"]*)\"?, line ([0-9]+)\\.[0-9]+:( (?:[A-Z]+|[0-9]+-)[0-9]+)? \\(([USEWI])\\)\\s*(.*)$");
    private static final Pattern PATTERN_2 = Pattern.compile("^(?:.*\\[.*\\])?\\s*\\s*((?:[A-Z]+|[0-9]+-)[0-9]+)?:? ?\\(([USEWI])\\)( INFORMATION:)?\\s*(.*)$");

    public XlcCompilerParser() {
        super(Messages._Warnings_Xlc_ParserName(), Messages._Warnings_Xlc_LinkName(), Messages._Warnings_Xlc_TrendName(), XLC_WARNING_PATTERN);
    }

    @Override
    protected String getId() {
        return "IBM XLC Compiler";
    }

    private Priority toPriority(String severity) {
        switch (severity.charAt(0)) {
            case 'E': 
            case 'S': 
            case 'U': {
                return Priority.HIGH;
            }
            case 'W': {
                return Priority.NORMAL;
            }
            case 'I': {
                return Priority.LOW;
            }
        }
        return Priority.HIGH;
    }

    @Override
    protected Warning createWarning(Matcher matcher0) {
        String line = matcher0.group(0);
        Matcher matcher = PATTERN_1.matcher(line);
        if (matcher.find()) {
            String fileName = matcher.group(1);
            int lineNumber = this.getLineNumber(matcher.group(2));
            String category = matcher.group(3).trim();
            String severity = matcher.group(4);
            Priority priority = this.toPriority(severity);
            String message = matcher.group(5);
            return this.createWarning(fileName, lineNumber, category, message, priority);
        }
        matcher = PATTERN_2.matcher(line);
        if (matcher.find()) {
            String fileName = "";
            int lineNumber = 0;
            String category = matcher.group(1).trim();
            String severity = matcher.group(2);
            Priority priority = this.toPriority(severity);
            String message = matcher.group(4);
            return this.createWarning(fileName, lineNumber, category, message, priority);
        }
        return FALSE_POSITIVE;
    }
}

