/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

@Deprecated
@Extension
public class PuppetLintParser
extends RegexpLineParser {
    private static final long serialVersionUID = 7492869677427430346L;
    private static final String SEPARATOR = "::";
    private static final String PUPPET_LINT_PATTERN_WARNING = "^\\s*((?:[A-Za-z]:)?[^:]+):([0-9]+):([^:]+):((?:WARNING)|(?:ERROR)):\\s*(.*)$";
    private static final String PUPPET_LINT_PATTERN_PACKAGE = "^(.*/?modules/)?([^/]*)/manifests(.*)?(/([^/]*)\\.pp)$";
    private final Pattern packagePattern = Pattern.compile("^(.*/?modules/)?([^/]*)/manifests(.*)?(/([^/]*)\\.pp)$");

    public PuppetLintParser() {
        super(Messages._Warnings_Puppet_ParserName(), Messages._Warnings_Puppet_LinkName(), Messages._Warnings_Puppet_TrendName(), PUPPET_LINT_PATTERN_WARNING);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String fileName = matcher.group(1);
        String start = matcher.group(2);
        String category = matcher.group(3);
        String level = matcher.group(4);
        String message = matcher.group(5);
        Priority priority = Priority.NORMAL;
        if (level.contains("error") || level.contains("ERROR")) {
            priority = Priority.HIGH;
        }
        Warning warning = this.createWarning(fileName, Integer.parseInt(start), category, message, priority);
        String moduleName = this.detectModuleName(fileName);
        if (StringUtils.isNotBlank((String)moduleName)) {
            warning.setPackageName(moduleName);
        }
        return warning;
    }

    private String detectModuleName(String fileName) {
        if (StringUtils.isNotBlank((String)fileName)) {
            return this.splitFileName(fileName);
        }
        return "";
    }

    private String splitFileName(String fileName) {
        Matcher matcher = this.packagePattern.matcher(fileName);
        if (matcher.find()) {
            String main = matcher.group(2);
            String subclassed = matcher.group(3);
            String module = SEPARATOR + main;
            if (StringUtils.isNotBlank((String)subclassed)) {
                module = module + StringUtils.replace((String)subclassed, (String)"/", (String)SEPARATOR);
            }
            return module;
        }
        return "";
    }
}

