/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

@Deprecated
@Extension
public class MavenConsoleParser
extends RegexpLineParser {
    private static final String CONSOLE = "";
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final int MAX_MESSAGE_LENGTH = 4000;
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String PATTERN = "^.*\\[(WARNING|ERROR)\\]\\s*(.*)$";

    public MavenConsoleParser() {
        super(Messages._Warnings_Maven_ParserName(), Messages._Warnings_Maven_LinkName(), Messages._Warnings_Maven_TrendName(), PATTERN, true);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(WARNING) || line.contains(ERROR);
    }

    @Override
    protected Warning createWarning(Matcher matcher) {
        String category;
        Priority priority;
        if (ERROR.equals(matcher.group(1))) {
            priority = Priority.HIGH;
            category = "Error";
        } else {
            priority = Priority.NORMAL;
            category = "Warning";
        }
        return this.createWarning(CONSOLE, this.getCurrentLine(), category, matcher.group(2), priority);
    }

    @Override
    protected Collection<FileAnnotation> postProcessWarnings(List<FileAnnotation> warnings) {
        LinkedList<Warning> condensed = new LinkedList<Warning>();
        int line = -1;
        for (FileAnnotation warning : warnings) {
            if (warning.getPrimaryLineNumber() == line + 1 && !condensed.isEmpty()) {
                FileAnnotation fileAnnotation = (FileAnnotation)condensed.getLast();
                if (fileAnnotation.getPriority() == warning.getPriority()) {
                    condensed.removeLast();
                    if (fileAnnotation.getMessage().length() + warning.getMessage().length() >= 4000) {
                        condensed.add(new Warning(fileAnnotation, warning.getPrimaryLineNumber()));
                    } else {
                        condensed.add(new Warning(fileAnnotation, warning.getMessage(), warning.getPrimaryLineNumber()));
                    }
                } else {
                    condensed.add((Warning)warning);
                }
            } else {
                condensed.add((Warning)warning);
            }
            line = warning.getPrimaryLineNumber();
        }
        ArrayList noBlank = Lists.newArrayList();
        for (FileAnnotation fileAnnotation : condensed) {
            if (!StringUtils.isNotBlank((String)fileAnnotation.getMessage())) continue;
            noBlank.add(fileAnnotation);
        }
        return noBlank;
    }
}

