/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import hudson.Extension;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.warnings.parser.Messages;
import hudson.plugins.warnings.parser.RegexpLineParser;
import hudson.plugins.warnings.parser.Warning;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
@Extension
public class XlcLinkerParser
extends RegexpLineParser {
    private static final long serialVersionUID = 211259620936831096L;
    private static final String XLC_LINKER_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)*\\s*(.*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_ERROR_1 = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+).*ERROR:\\s*(.*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_ERROR_2 = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(Error .*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_WARNING = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*WARNING:\\s*(.*)$";
    private static final String XLC_LINKER_WARNING_PATTERN_INFO = "^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(.*)$";
    private static final Pattern PATTERN_ERROR_1 = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+).*ERROR:\\s*(.*)$");
    private static final Pattern PATTERN_ERROR_2 = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(Error .*)$");
    private static final Pattern PATTERN_WARNING = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*WARNING:\\s*(.*)$");
    private static final Pattern PATTERN_INFO = Pattern.compile("^(?:.*\\[.*\\])?\\s*ld: ([0-9]+-[0-9]+)\\s*(.*)$");

    public XlcLinkerParser() {
        super(Messages._Warnings_Xlc_ParserName(), Messages._Warnings_Xlc_LinkName(), Messages._Warnings_Xlc_TrendName(), XLC_LINKER_WARNING_PATTERN);
    }

    @Override
    protected String getId() {
        return "IBM XLC Linker";
    }

    @Override
    protected Warning createWarning(Matcher matcher0) {
        String line = matcher0.group(0);
        Matcher matcher = PATTERN_ERROR_1.matcher(line);
        if (matcher.find()) {
            String category = matcher.group(1);
            String message = matcher.group(2);
            return this.createWarning("", 0, category, message, Priority.HIGH);
        }
        matcher = PATTERN_ERROR_2.matcher(line);
        if (matcher.find()) {
            String category = matcher.group(1);
            String message = matcher.group(2);
            return this.createWarning("", 0, category, message, Priority.HIGH);
        }
        matcher = PATTERN_WARNING.matcher(line);
        if (matcher.find()) {
            String category = matcher.group(1);
            String message = matcher.group(2);
            return this.createWarning("", 0, category, message, Priority.NORMAL);
        }
        matcher = PATTERN_INFO.matcher(line);
        if (matcher.find()) {
            String category = matcher.group(1);
            String message = matcher.group(2);
            return this.createWarning("", 0, category, message, Priority.LOW);
        }
        return FALSE_POSITIVE;
    }
}

