/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.warnings.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.NullLogger;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.warnings.GroovyParser;
import hudson.plugins.warnings.Messages;
import hudson.plugins.warnings.WarningsDescriptor;
import hudson.plugins.warnings.parser.AbstractWarningsParser;
import hudson.plugins.warnings.parser.IntelParser;
import hudson.plugins.warnings.parser.MsBuildParser;
import hudson.plugins.warnings.parser.ParserDescription;
import hudson.plugins.warnings.parser.ParsingCanceledException;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;

@Deprecated
public class ParserRegistry {
    private final List<AbstractWarningsParser> parsers;
    private final Charset defaultCharset;

    private static List<AbstractWarningsParser> all() {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return Lists.newArrayList();
        }
        ArrayList parsers = Lists.newArrayList((Iterable)instance.getExtensionList(AbstractWarningsParser.class));
        return parsers;
    }

    public static ListBoxModel getParsersAsListModel() {
        ListBoxModel items = new ListBoxModel();
        for (ParserDescription parser : ParserRegistry.getAvailableParsers()) {
            items.add(parser.getName(), parser.getGroup());
        }
        return items;
    }

    public static List<ParserDescription> getAvailableParsers() {
        HashSet groups = Sets.newHashSet();
        for (AbstractWarningsParser parser : ParserRegistry.getAllParsers()) {
            groups.add(parser.getGroup());
        }
        ArrayList sorted = Lists.newArrayList();
        for (String group : groups) {
            sorted.add(new ParserDescription(group, ParserRegistry.getParser(group).getParserName()));
        }
        Collections.sort(sorted);
        return sorted;
    }

    public static AbstractWarningsParser getParser(@CheckForNull String group) {
        if (StringUtils.isEmpty((String)group)) {
            return new NullWarnigsParser("NULL");
        }
        List<AbstractWarningsParser> parsers = ParserRegistry.getParsers(group);
        if (parsers.isEmpty()) {
            return new NullWarnigsParser(group);
        }
        return parsers.get(0);
    }

    public static List<AbstractWarningsParser> getParsers(String group) {
        return ParserRegistry.getParsers(Collections.singleton(group));
    }

    public static int getUrl(String group) {
        List<AbstractWarningsParser> allParsers = ParserRegistry.getAllParsers();
        for (int number = 0; number < allParsers.size(); ++number) {
            if (!allParsers.get(number).isInGroup(group)) continue;
            return number;
        }
        throw new NoSuchElementException("No parser found for group: " + group);
    }

    public static List<AbstractWarningsParser> getParsers(Collection<String> parserGroups) {
        ArrayList<AbstractWarningsParser> actualParsers = new ArrayList<AbstractWarningsParser>();
        for (String name : parserGroups) {
            for (AbstractWarningsParser warningsParser : ParserRegistry.getAllParsers()) {
                if (!warningsParser.isInGroup(name)) continue;
                actualParsers.add(warningsParser);
            }
        }
        return actualParsers;
    }

    public static boolean exists(String parserName) {
        return !ParserRegistry.getParsers(parserName).isEmpty();
    }

    private static List<AbstractWarningsParser> getAllParsers() {
        ArrayList parsers = Lists.newArrayList();
        parsers.add(new MsBuildParser(hudson.plugins.warnings.parser.Messages._Warnings_PCLint_ParserName(), hudson.plugins.warnings.parser.Messages._Warnings_PCLint_LinkName(), hudson.plugins.warnings.parser.Messages._Warnings_PCLint_TrendName()));
        parsers.add(new IntelParser(hudson.plugins.warnings.parser.Messages._Warnings_IntelFortran_ParserName(), hudson.plugins.warnings.parser.Messages._Warnings_IntelFortran_LinkName(), hudson.plugins.warnings.parser.Messages._Warnings_IntelFortran_TrendName()));
        Iterable<GroovyParser> parserDescriptions = ParserRegistry.getDynamicParserDescriptions();
        parsers.addAll(ParserRegistry.getDynamicParsers(parserDescriptions));
        parsers.addAll(ParserRegistry.all());
        return ImmutableList.copyOf((Collection)parsers);
    }

    private static Iterable<GroovyParser> getDynamicParserDescriptions() {
        WarningsDescriptor descriptor;
        Jenkins instance = Jenkins.getInstance();
        if (instance != null && (descriptor = (WarningsDescriptor)instance.getDescriptorByType(WarningsDescriptor.class)) != null) {
            return Lists.newArrayList((Object[])descriptor.getParsers());
        }
        return Collections.emptyList();
    }

    static List<AbstractWarningsParser> getDynamicParsers(Iterable<GroovyParser> parserDescriptions) {
        ArrayList parsers = Lists.newArrayList();
        for (GroovyParser description : parserDescriptions) {
            if (!description.isValid()) continue;
            parsers.add(description.getParser());
        }
        return parsers;
    }

    public ParserRegistry(List<? extends AbstractWarningsParser> parsers, String defaultEncoding) {
        this.defaultCharset = EncodingValidator.defaultCharset((String)defaultEncoding);
        this.parsers = new ArrayList<AbstractWarningsParser>(parsers);
        if (this.parsers.isEmpty()) {
            this.parsers.addAll(ParserRegistry.getAllParsers());
        }
    }

    public Collection<FileAnnotation> parse(File file) throws IOException {
        return this.parse(file, (PluginLogger)new NullLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileAnnotation> parse(File file, PluginLogger logger) throws IOException {
        HashSet allAnnotations = Sets.newHashSet();
        for (AbstractWarningsParser parser : this.parsers) {
            Reader input = null;
            try {
                input = this.createReader(file);
                Collection<FileAnnotation> warnings = parser.parse(input);
                logger.log(String.format("%s : Found %d warnings.", parser.getParserName(), warnings.size()));
                allAnnotations.addAll(warnings);
            }
            finally {
                IOUtils.closeQuietly((Reader)input);
            }
        }
        return allAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileAnnotation> parse(InputStream file) throws IOException {
        try {
            HashSet allAnnotations = Sets.newHashSet();
            for (AbstractWarningsParser parser : this.parsers) {
                allAnnotations.addAll(parser.parse(this.createReader(file)));
            }
            HashSet hashSet = allAnnotations;
            return hashSet;
        }
        finally {
            IOUtils.closeQuietly((InputStream)file);
        }
    }

    @SuppressFBWarnings(value={"OBL"})
    protected Reader createReader(File file) throws FileNotFoundException {
        return this.createReader(new FileInputStream(file));
    }

    protected Reader createReader(InputStream inputStream) {
        return new InputStreamReader((InputStream)new BOMInputStream(inputStream), this.defaultCharset);
    }

    private static final class NullWarnigsParser
    extends AbstractWarningsParser {
        private static final long serialVersionUID = 1L;

        NullWarnigsParser(String group) {
            super(hudson.plugins.warnings.parser.Messages._Warnings_NotLocalizedName(group), Messages._Warnings_ProjectAction_Name(), Messages._Warnings_Trend_Name());
        }

        @Override
        public Collection<FileAnnotation> parse(Reader reader) throws IOException, ParsingCanceledException {
            return Collections.emptyList();
        }
    }
}

