/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.util;

import hudson.plugins.testlink.TestLinkBuildAction;
import hudson.plugins.testlink.TestLinkReport;
import hudson.plugins.testlink.TestLinkResult;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class ChartUtil {
    public static JFreeChart buildXYChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Build #", null, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesPaint(0, (Paint)Color.green);
        renderer.setSeriesPaint(1, (Paint)Color.red);
        renderer.setSeriesPaint(2, (Paint)Color.orange);
        renderer.setSeriesPaint(3, (Paint)Color.blue);
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    public static final XYDataset createXYDataset(TestLinkBuildAction lastAction) {
        TestLinkBuildAction tempAction = lastAction;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries passedTests = new XYSeries((Comparable)((Object)"Passed Tests"));
        XYSeries failedTests = new XYSeries((Comparable)((Object)"Failed Tests"));
        XYSeries blockedTests = new XYSeries((Comparable)((Object)"Blocked Tests"));
        XYSeries totalTests = new XYSeries((Comparable)((Object)"Total Tests"));
        dataset.addSeries(passedTests);
        dataset.addSeries(failedTests);
        dataset.addSeries(blockedTests);
        dataset.addSeries(totalTests);
        do {
            TestLinkResult result = tempAction.getResult();
            TestLinkReport report = result.getReport();
            int buildNumber = tempAction.getBuild().number;
            totalTests.add((double)buildNumber, (double)report.getTestsTotal());
            passedTests.add((double)buildNumber, (double)report.getTestsPassed());
            failedTests.add((double)buildNumber, (double)report.getTestsFailed());
            blockedTests.add((double)buildNumber, (double)report.getTestsBlocked());
        } while ((tempAction = tempAction.getPreviousAction()) != null);
        return dataset;
    }
}

