/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.testlink.SVNHelper;
import hudson.plugins.testlink.TestLinkBuilderDescriptor;
import hudson.plugins.testlink.TestLinkBuilderInstallation;
import hudson.plugins.testlink.TestLinkLatestRevisionInfo;
import hudson.plugins.testlink.model.TestLinkTestCase;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.tmatesoft.svn.core.SVNException;
import testlink.api.java.client.TestLinkAPIClient;
import testlink.api.java.client.TestLinkAPIException;
import testlink.api.java.client.TestLinkAPIResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkBuilder
extends Builder {
    private TestLinkAPIClient testLinkClient = null;
    private final String testLinkName;
    private final String projectName;
    private Integer projectId;
    private final String testPlanName;
    private Integer testPlanId;
    private String buildName;
    private Integer buildId;
    private final TestLinkLatestRevisionInfo latestRevisionInfo;
    private final String mavenTestProjectDirectory;
    private final String mavenInstallationName;
    private final String mavenTestProjectGoal;
    private String mavenExecutable;
    private final Boolean transactional;
    private static final String DEFAULT_MAVEN_GOAL = "test";
    @Extension
    public static final TestLinkBuilderDescriptor DESCRIPTOR = new TestLinkBuilderDescriptor();
    private static final String BUILD_NOTES = "Build created automatically with Hudson TestLink plug-in.";
    private static final String TEST_CASE_EXECUTION_NOTES = "Test executed by Hudson TestLink plug-in.";
    private String testCategoryCustomField = null;
    private String testFileCustomField = null;
    private String testCaseCategory;
    private String testSuiteCategory;

    @DataBoundConstructor
    public TestLinkBuilder(String testLinkName, String projectName, String testPlanName, String buildName, TestLinkLatestRevisionInfo latestRevisionInfo, String mavenTestProjectDirectory, String mavenInstallationName, String mavenTestProjectGoal, Boolean transactional) {
        this.testLinkName = testLinkName;
        this.projectName = projectName;
        this.testPlanName = testPlanName;
        this.buildName = buildName;
        this.latestRevisionInfo = latestRevisionInfo;
        this.mavenTestProjectDirectory = mavenTestProjectDirectory;
        this.mavenInstallationName = mavenInstallationName;
        this.mavenTestProjectGoal = mavenTestProjectGoal;
        this.transactional = transactional;
    }

    public String getTestLinkName() {
        return this.testLinkName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public void setTestPlanId(Integer testPlanId) {
        this.testPlanId = testPlanId;
    }

    public String getTestPlanName() {
        return this.testPlanName;
    }

    public Integer getTestPlanId() {
        return this.testPlanId;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public Integer getBuildId() {
        return this.buildId;
    }

    public void setBuildId(Integer id) {
        this.buildId = id;
    }

    public TestLinkLatestRevisionInfo getLatestRevisionInfo() {
        return this.latestRevisionInfo;
    }

    public Boolean getLatestRevisionEnabled() {
        return this.latestRevisionInfo != null;
    }

    public String getMavenTestProjectDirectory() {
        return this.mavenTestProjectDirectory;
    }

    public String getMavenInstallationName() {
        return this.mavenInstallationName;
    }

    public List<Maven.MavenInstallation> getMavenInstallations() {
        return Arrays.asList(((Maven.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations());
    }

    public String getMavenTestProjectGoal() {
        if (this.mavenTestProjectGoal == null) {
            return DEFAULT_MAVEN_GOAL;
        }
        return this.mavenTestProjectGoal;
    }

    public String getMavenExecutable() {
        return this.mavenExecutable;
    }

    public void setMavenExecutable(String mavenExecutable) {
        this.mavenExecutable = mavenExecutable;
    }

    public boolean validMaven() {
        return new File(this.mavenExecutable).exists();
    }

    public Boolean getTransactional() {
        return this.transactional;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Preparing TestLink client API");
        TestLinkBuilderInstallation installation = DESCRIPTOR.getInstallationByTestLinkName(this.testLinkName);
        if (installation == null) {
            listener.fatalError("Invalid TestLink installation");
            return false;
        }
        this.testLinkClient = new TestLinkAPIClient(installation.getDevKey(), installation.getUrl());
        if (!this.verifyMaven(launcher)) {
            listener.fatalError("Invalid Maven executable. Please check your maven installation or refer to documentation.");
            return false;
        }
        listener.getLogger().println("Updating TestLink Custom Fields values from installation");
        this.setupCustomFields(installation);
        if (this.getLatestRevisionEnabled().booleanValue()) {
            listener.getLogger().println("Using SVN latest revision from repository as Build Name");
            SVNHelper svn = new SVNHelper(this.latestRevisionInfo.getSvnUrl(), this.latestRevisionInfo.getSvnUser(), this.latestRevisionInfo.getSvnPassword());
            try {
                this.buildName = Long.toString(svn.getLatestRevision());
            }
            catch (SVNException e) {
                e.printStackTrace(listener.fatalError("Error retrieving latest revision from SVN repository: " + e.getMessage()));
                return false;
            }
        }
        listener.getLogger().println("Updating TestLink parameters");
        try {
            if (!this.updateTestLinkParameters()) {
                listener.fatalError("Invalid TestLink parameters. Check TestLink and Hudson Job parameters.");
                return false;
            }
        }
        catch (TestLinkAPIException e) {
            e.printStackTrace(listener.fatalError("Invalid TestLink parameters: " + e.getMessage()));
            return false;
        }
        listener.getLogger().println("Retrieving list of automated test cases");
        ArrayList<TestLinkTestCase> automatedTests = new ArrayList<TestLinkTestCase>();
        try {
            this.retrieveListOfAutomatedTests(automatedTests, listener);
        }
        catch (TestLinkAPIException e) {
            e.printStackTrace(listener.fatalError("Error retrieving list of automated test cases: " + e.getMessage()));
            return false;
        }
        boolean failure = false;
        for (TestLinkTestCase testCase : automatedTests) {
            if (this.transactional.booleanValue() && failure) {
                testCase.setResultStatus("b");
            } else {
                failure = this.executeTestCase(testCase, build, listener, launcher);
            }
            try {
                this.updateTestCaseResultStatus(testCase);
            }
            catch (TestLinkAPIException e) {
                e.printStackTrace(listener.fatalError("Error updating Test Case status: " + e.getMessage()));
                return false;
            }
        }
        FilePath workspace = build.getWorkspace();
        File reportFile = new File(workspace.getRemote(), "testlink.xml");
        try {
            this.writeTestLinkReportFile(this.buildName, this.buildId, automatedTests, reportFile);
        }
        catch (IOException ioe) {
            Util.displayIOException((IOException)ioe, (TaskListener)listener);
            ioe.printStackTrace(listener.fatalError("Error writing testlink.xml report: " + ioe.getMessage()));
            return false;
        }
        return true;
    }

    private void setupCustomFields(TestLinkBuilderInstallation installation) {
        this.testFileCustomField = installation.getTestFileCustomField();
        this.testCategoryCustomField = installation.getTestCategoryCustomField();
        this.testCaseCategory = installation.getTestCaseCategory();
        this.testSuiteCategory = installation.getTestSuiteCategory();
    }

    private boolean verifyMaven(Launcher launcher) {
        List<Maven.MavenInstallation> mavenInstallations = this.getMavenInstallations();
        for (Maven.MavenInstallation inst : mavenInstallations) {
            if (!inst.getName().equals(this.mavenInstallationName)) continue;
            try {
                this.mavenExecutable = inst.getExecutable(launcher);
            }
            catch (Exception e) {
                this.mavenExecutable = this.mavenInstallationName + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "mvn";
            }
            return true;
        }
        return false;
    }

    private boolean verifyTestCase(TestLinkTestCase tc) {
        return !StringUtils.isEmpty((String)tc.getCategory()) && !StringUtils.isEmpty((String)tc.getFile()) && (tc.getCategory().equals(this.testCaseCategory) || tc.getCategory().equals(this.testSuiteCategory));
    }

    private boolean updateTestLinkParameters() throws TestLinkAPIException {
        TestLinkAPIResults projects = this.testLinkClient.getProjects();
        int projectsSize = projects.size();
        if (projectsSize == 0) {
            return false;
        }
        for (int i = 0; i < projectsSize; ++i) {
            Map oProject;
            Map project = oProject = projects.getData(i);
            String projectName = "" + project.get("name");
            if (!this.projectName.equals(projectName)) continue;
            Object oProjectID = projects.getValueByName(i, "id");
            Integer projectID = Integer.parseInt(oProjectID.toString());
            this.setProjectId(projectID);
            break;
        }
        if (this.getProjectId() <= 0) {
            return false;
        }
        TestLinkAPIResults projectTestPlans = this.testLinkClient.getProjectTestPlans(this.projectName);
        Object o = projectTestPlans.getValueByName(0, "id");
        Integer planID = Integer.parseInt(o.toString());
        this.setTestPlanId(planID);
        Integer buildID = this.testLinkClient.createBuild(planID, this.buildName, BUILD_NOTES);
        this.setBuildId(buildID);
        return true;
    }

    private void retrieveListOfAutomatedTests(List<TestLinkTestCase> automatedTests, BuildListener listener) throws TestLinkAPIException {
        TestLinkAPIResults results = this.testLinkClient.getCasesForTestPlan(this.getTestPlanId());
        int resultsSize = results.size();
        for (int i = 0; i < resultsSize; ++i) {
            String executionType;
            Map result = results.getData(i);
            Object o = result.get("execution_type");
            if (o == null || !"2".equals(executionType = (String)o)) continue;
            TestLinkTestCase tc = this.convertMapToTestCase(result);
            if (this.verifyTestCase(tc)) {
                automatedTests.add(tc);
                continue;
            }
            listener.getLogger().println("Invalid automated Test Case found: " + tc);
        }
    }

    private TestLinkTestCase convertMapToTestCase(Map<?, ?> testCase) throws TestLinkAPIException {
        TestLinkTestCase tc = new TestLinkTestCase();
        tc.setPlanId(this.getTestPlanId());
        tc.setBuildId(this.getBuildId());
        int testCaseId = Integer.parseInt(testCase.get("tc_id").toString());
        TestLinkAPIResults apiResults = this.testLinkClient.getTestCaseCustomFieldDesignValue(Integer.valueOf(testCaseId), this.getProjectId(), this.testCategoryCustomField, "full");
        tc.setId(testCaseId);
        String testCaseCategory = apiResults.getValueByName(0, "value").toString();
        tc.setCategory(testCaseCategory);
        apiResults = this.testLinkClient.getTestCaseCustomFieldDesignValue(Integer.valueOf(testCaseId), this.getProjectId(), this.testFileCustomField, "full");
        String testCaseFile = apiResults.getValueByName(0, "value").toString();
        tc.setFile(testCaseFile);
        return tc;
    }

    private boolean executeTestCase(TestLinkTestCase tc, AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher) {
        String mavenExecutable = this.getMavenExecutable();
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(mavenExecutable);
        args.add(new String[]{"-f", this.mavenTestProjectDirectory + System.getProperty("file.separator") + "pom.xml"});
        if (tc.getCategory().equals(this.testCaseCategory)) {
            args.add(new String[]{this.mavenTestProjectGoal, "-Dtest=" + tc.getFile()});
        } else if (tc.getCategory().equals(this.testSuiteCategory)) {
            args.add(new String[]{this.mavenTestProjectGoal, "-Dsuite=" + tc.getFile()});
        } else {
            listener.fatalError("Invalid test category: " + tc);
            return false;
        }
        args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        listener.getLogger().println("Executing command: " + args.toStringWithQuote());
        int exitCode = -1;
        try {
            EnvVars env = build.getEnvironment((TaskListener)listener);
            Launcher.ProcStarter ps = launcher.launch();
            ps.cmds(args);
            ps.envs((Map)env);
            ps.stdout((TaskListener)listener);
            ps.pwd(build.getModuleRoot());
            exitCode = ps.join();
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Command execution failed"));
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.fatalError("Command execution failed"));
        }
        tc.setResultStatus(this.getTestLinkTCStatus(exitCode));
        return tc.getResultStatus().equals("f");
    }

    private String getTestLinkTCStatus(int exitCode) {
        if (exitCode == 0) {
            return "p";
        }
        return "f";
    }

    private void updateTestCaseResultStatus(TestLinkTestCase tc) throws TestLinkAPIException {
        this.testLinkClient.reportTestCaseResult(Integer.valueOf(tc.getPlanId()), Integer.valueOf(tc.getId()), Integer.valueOf(tc.getBuildId()), TEST_CASE_EXECUTION_NOTES, tc.getResultStatus());
    }

    private void writeTestLinkReportFile(String buildName, Integer buildId, List<TestLinkTestCase> automatedTests, File reportFile) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<testlink>\n");
        buffer.append("\t<buildName>" + buildName + "</buildName>\n");
        for (TestLinkTestCase tc : automatedTests) {
            buffer.append(tc.toXml());
        }
        buffer.append("</testlink>\n");
        FileWriter writer = new FileWriter(reportFile);
        writer.append(buffer.toString());
        writer.flush();
        writer.close();
    }
}

