/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.testlink.ReportSummary;
import hudson.plugins.testlink.TestLinkReport;
import hudson.plugins.testlink.TestLinkResult;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkBuildAction
implements Action,
Serializable,
StaplerProxy {
    public static final String DISPLAY_NAME = "TestLink";
    public static final String ICON_FILE_NAME = "/plugin/testlink/icons/testlink-24.png";
    public static final String URL_NAME = "testLinkResult";
    private AbstractBuild<?, ?> build;
    private TestLinkResult result;

    public TestLinkBuildAction(AbstractBuild<?, ?> build, TestLinkResult result) {
        this.build = build;
        this.result = result;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getIconFileName() {
        return ICON_FILE_NAME;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public Object getTarget() {
        return this.result;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public TestLinkResult getResult() {
        return this.result;
    }

    private TestLinkReport getPreviousReport() {
        TestLinkResult previousResult = this.getPreviousResult();
        TestLinkReport previousReport = null;
        if (previousResult != null) {
            previousReport = previousResult.getReport();
        }
        return previousReport;
    }

    public TestLinkResult getPreviousResult() {
        TestLinkBuildAction previousAction = this.getPreviousAction();
        TestLinkResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    public TestLinkBuildAction getPreviousAction() {
        AbstractBuild previousBuild;
        if (this.build != null && (previousBuild = (AbstractBuild)this.build.getPreviousBuild()) != null) {
            return (TestLinkBuildAction)previousBuild.getAction(TestLinkBuildAction.class);
        }
        return null;
    }

    public String getSummary() {
        return ReportSummary.createReportSummary(this.result.getReport(), this.getPreviousReport());
    }

    public String getDetails() {
        return ReportSummary.createReportSummaryDetails(this.result.getReport(), this.getPreviousReport());
    }
}

