/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import java.net.MalformedURLException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class SVNHelper {
    private final String repoUrl;
    private final String userName;
    private final String password;

    public SVNHelper(String repoUrl, String userName, String password) throws MalformedURLException {
        this.repoUrl = repoUrl;
        this.userName = userName;
        this.password = password;
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
    }

    public String getRepositoryURL() {
        return this.repoUrl;
    }

    public long getLatestRevision() throws SVNException {
        SVNRepository repository = null;
        SVNURL svnURL = SVNURL.parseURIEncoded((String)this.getRepositoryURL());
        repository = SVNRepositoryFactory.create((SVNURL)svnURL);
        if (this.userName != null) {
            BasicAuthenticationManager authManager = new BasicAuthenticationManager(this.userName, this.password);
            repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        }
        SVNDirEntry entry = repository.getDir("", -1L, false, null);
        return entry.getRevision();
    }
}

