/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.scm.SubversionSCM;
import hudson.security.csrf.CrumbIssuer;
import hudson.util.IOException2;
import hudson.util.MultipartFormDataParser;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.kohsuke.putty.PuTTYKey;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class UserProvidedCredential
implements Closeable {
    private final String username;
    private final String password;
    private final File keyFile;
    private static final Logger LOGGER = Logger.getLogger(UserProvidedCredential.class.getName());

    public UserProvidedCredential(String username, String password, File keyFile) {
        this.username = username;
        this.password = password;
        this.keyFile = keyFile;
    }

    public static UserProvidedCredential fromForm(StaplerRequest req, MultipartFormDataParser parser) throws IOException {
        FileItem item;
        File keyFile;
        CrumbIssuer crumbIssuer = Hudson.getInstance().getCrumbIssuer();
        if (crumbIssuer != null && !crumbIssuer.validateCrumb((ServletRequest)req, parser)) {
            throw HttpResponses.error((int)403, (Throwable)new IOException("No crumb found"));
        }
        String kind = parser.get("kind");
        int idx = Arrays.asList("", "password", "publickey", "certificate").indexOf(kind);
        String username = parser.get("username" + idx);
        String password = parser.get("password" + idx);
        if (idx <= 1) {
            keyFile = null;
            item = null;
        } else {
            item = parser.getFileItem(kind.equals("publickey") ? "privateKey" : "certificate");
            keyFile = File.createTempFile("hudson", "key");
            if (item != null) {
                try {
                    item.write(keyFile);
                }
                catch (Exception e) {
                    throw new IOException2((Throwable)e);
                }
                if (PuTTYKey.isPuTTYKeyFile((File)keyFile)) {
                    LOGGER.info("Converting " + keyFile + " from PuTTY format to OpenSSH format");
                    new PuTTYKey(keyFile, null).toOpenSSH(keyFile);
                }
            }
        }
        return new UserProvidedCredential(username, password, keyFile){

            public void close() throws IOException {
                if (keyFile != null) {
                    keyFile.delete();
                }
                if (item != null) {
                    item.delete();
                }
            }
        };
    }

    public void close() throws IOException {
    }

    public class AuthenticationManagerImpl
    extends DefaultSVNAuthenticationManager {
        private SubversionSCM.DescriptorImpl.Credential cred;
        private final PrintWriter logWriter;
        boolean authenticationAttempted;
        boolean authenticationAcknowledged;

        public AuthenticationManagerImpl(PrintWriter logWriter) {
            super(SVNWCUtil.getDefaultConfigurationDirectory(), true, UserProvidedCredential.this.username, UserProvidedCredential.this.password, UserProvidedCredential.this.keyFile, UserProvidedCredential.this.password);
            this.logWriter = logWriter;
        }

        public AuthenticationManagerImpl(Writer w) {
            this(new PrintWriter(w));
        }

        public AuthenticationManagerImpl(TaskListener listener) {
            this(new PrintWriter(listener.getLogger(), true));
        }

        public SVNAuthentication getFirstAuthentication(String kind, String realm, SVNURL url) throws SVNException {
            this.authenticationAttempted = true;
            if (kind.equals("svn.username")) {
                return new SVNUserNameAuthentication(UserProvidedCredential.this.username, false);
            }
            if (kind.equals("svn.simple")) {
                this.logWriter.println("Passing user name " + UserProvidedCredential.this.username + " and password you entered");
                this.cred = new SubversionSCM.DescriptorImpl.PasswordCredential(UserProvidedCredential.this.username, UserProvidedCredential.this.password);
            }
            if (kind.equals("svn.ssh")) {
                if (UserProvidedCredential.this.keyFile == null) {
                    this.logWriter.println("Passing user name " + UserProvidedCredential.this.username + " and password you entered to SSH");
                    this.cred = new SubversionSCM.DescriptorImpl.PasswordCredential(UserProvidedCredential.this.username, UserProvidedCredential.this.password);
                } else {
                    this.logWriter.println("Attempting a public key authentication with username " + UserProvidedCredential.this.username);
                    this.cred = new SubversionSCM.DescriptorImpl.SshPublicKeyCredential(UserProvidedCredential.this.username, UserProvidedCredential.this.password, UserProvidedCredential.this.keyFile);
                }
            }
            if (kind.equals("svn.ssl")) {
                this.logWriter.println("Attempting an SSL client certificate authentcation");
                try {
                    this.cred = new SubversionSCM.DescriptorImpl.SslClientCertificateCredential(UserProvidedCredential.this.keyFile, UserProvidedCredential.this.password);
                }
                catch (IOException e) {
                    e.printStackTrace(this.logWriter);
                    return null;
                }
            }
            if (this.cred == null) {
                this.logWriter.println("Unknown authentication method: " + kind);
                return null;
            }
            return this.cred.createSVNAuthentication(kind);
        }

        public SVNAuthentication getNextAuthentication(String kind, String realm, SVNURL url) throws SVNException {
            SVNErrorManager.authenticationFailed((String)("Authentication failed for " + url), null);
            return null;
        }

        public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
            this.authenticationAcknowledged = true;
            if (accepted) {
                assert (this.cred != null);
                this.onSuccess(realm, this.cred);
            } else {
                this.logWriter.println("Failed to authenticate: " + errorMessage);
                if (errorMessage.getCause() != null) {
                    errorMessage.getCause().printStackTrace(this.logWriter);
                }
            }
            super.acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication);
        }

        protected void onSuccess(String realm, SubversionSCM.DescriptorImpl.Credential cred) {
        }

        public void checkIfProtocolCompleted() throws SVNCancelException {
            if (!this.authenticationAttempted) {
                this.logWriter.println("No authentication was attemped.");
                throw new SVNCancelException();
            }
            if (!this.authenticationAcknowledged) {
                this.logWriter.println("Authentication was not acknowledged.");
                throw new SVNCancelException();
            }
        }
    }
}

