/*
 * Decompiled with CFR 0.152.
 */
package hpi;

import hpi.SaxParser;
import hpi.ScriptSelectionTaskDefinition;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.FileParameterDefinition;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterDefinition;
import hudson.model.RunParameterDefinition;
import hudson.model.StringParameterDefinition;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.xml.parsers.ParserConfigurationException;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableConfigsPlugin
implements Action {
    private final AbstractProject<?, ?> project;
    private static final String defaultDir = "storable-configs";

    public StorableConfigsPlugin(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "Storable configs";
    }

    public String getIconFileName() {
        return "/plugin/storable-configs-plugin/storableConfigs.png";
    }

    public String getUrlName() {
        return "storable-configs-plugin";
    }

    public String getFullName() {
        return this.project.getFullName();
    }

    public void doSaveSettings(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkConfigurePermission();
        try {
            String filename = req.getParameter("filename") + ".xml";
            FilePath file = new FilePath(this.getStorableConfigsDir(), filename);
            file.touch(new Date().getTime());
            PrintWriter pw = new PrintWriter(file.write(), true);
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<Parameters>");
            ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
            List pdlist = pdp.getParameterDefinitions();
            for (ParameterDefinition pd : pdlist) {
                if (pd instanceof BooleanParameterDefinition) {
                    pw.println("<Parameter>");
                    pw.println("<Name>" + pd.getName() + "</Name>");
                    pw.println("<Description>" + pd.getDescription() + "</Description>");
                    BooleanParameterDefinition bpd = (BooleanParameterDefinition)pd;
                    pw.println("<Type>Boolean</Type>");
                    pw.println("<Value>" + bpd.isDefaultValue() + "</Value>");
                    pw.println("</Parameter>");
                    continue;
                }
                if (pd instanceof ChoiceParameterDefinition) {
                    pw.println("<Parameter>");
                    pw.println("<Name>" + pd.getName() + "</Name>");
                    pw.println("<Description>" + pd.getDescription() + "</Description>");
                    ChoiceParameterDefinition cpd = (ChoiceParameterDefinition)pd;
                    pw.println("<Type>Choice</Type>");
                    pw.println("<Choices>");
                    List strings = cpd.getChoices();
                    for (String str : strings) {
                        pw.println("<Choice>" + str + "</Choice>");
                    }
                    pw.println("</Choices>");
                    pw.println("</Parameter>");
                    continue;
                }
                if (pd instanceof StringParameterDefinition) {
                    pw.println("<Parameter>");
                    pw.println("<Name>" + pd.getName() + "</Name>");
                    pw.println("<Description>" + pd.getDescription() + "</Description>");
                    StringParameterDefinition spd = (StringParameterDefinition)pd;
                    pw.println("<Type>String</Type>");
                    pw.println("<Value>" + spd.getDefaultValue() + "</Value>");
                    pw.println("</Parameter>");
                    continue;
                }
                if (pd instanceof PasswordParameterDefinition) {
                    pw.println("<Parameter>");
                    pw.println("<Name>" + pd.getName() + "</Name>");
                    pw.println("<Description>" + pd.getDescription() + "</Description>");
                    PasswordParameterDefinition ppd = (PasswordParameterDefinition)pd;
                    pw.println("<Type>Password</Type>");
                    pw.println("<Value>" + ppd.getDefaultValue() + "</Value>");
                    pw.println("</Parameter>");
                    continue;
                }
                if (pd instanceof RunParameterDefinition) {
                    pw.println("<Parameter>");
                    pw.println("<Name>" + pd.getName() + "</Name>");
                    pw.println("<Description>" + pd.getDescription() + "</Description>");
                    RunParameterDefinition rpd = (RunParameterDefinition)pd;
                    pw.println("<Type>Run</Type>");
                    pw.println("<Value>" + rpd.getProjectName() + "</Value>");
                    pw.println("</Parameter>");
                    continue;
                }
                if (pd instanceof FileParameterDefinition) {
                    pw.println("<Parameter>");
                    pw.println("<Name>" + pd.getName() + "</Name>");
                    pw.println("<Description>" + pd.getDescription() + "</Description>");
                    pw.println("<Type>File</Type>");
                    pw.println("</Parameter>");
                    continue;
                }
                if (Hudson.getInstance().getPlugin("selection-tasks-plugin") == null || !(pd instanceof ScriptSelectionTaskDefinition)) continue;
                pw.println("<Parameter>");
                pw.println("<Name>" + pd.getName() + "</Name>");
                pw.println("<Description>" + pd.getDescription() + "</Description>");
                ScriptSelectionTaskDefinition td = (ScriptSelectionTaskDefinition)pd;
                pw.println("<Type>hpi.ScriptSelectionTaskDefinition</Type>");
                pw.println("<Path>" + td.getPath() + "</Path>");
                pw.println("<TestDelimSymbol>" + td.getTestDelimSymbol() + "</TestDelimSymbol>");
                pw.println("<NodeDelimSymbol>" + td.getNodeDelimSymbol() + "</NodeDelimSymbol>");
                pw.println("<CountDelimiterSymbol>" + td.getCountDelimiterSymbol() + "</CountDelimiterSymbol>");
                pw.println("<Delimiter>" + td.getDelimiter() + "</Delimiter>");
                pw.println("<Value>" + td.getDefaultValue() + "</Value>");
                pw.println("</Parameter>");
            }
            pw.println("</Parameters>");
            pw.close();
            rsp.sendRedirect(req.getRootPath() + "/job/" + this.getFullName() + "/" + this.getUrlName());
        }
        catch (Exception e) {
            rsp.sendError(450, e.getMessage());
        }
    }

    public void doChangeSettings(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, SAXException, ParserConfigurationException {
        this.checkConfigurePermission();
        String filename = Stapler.getCurrentRequest().getParameter("group");
        File configFile = new File(this.getConfigsDir(), filename);
        SaxParser parser = new SaxParser(configFile);
        List<ParameterDefinition> params = parser.load();
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)this.project.getProperty(ParametersDefinitionProperty.class);
        List projectParams = pdp.getParameterDefinitions();
        projectParams.clear();
        for (ParameterDefinition parameterDefinition : params) {
            projectParams.add(parameterDefinition);
        }
        this.project.save();
        rsp.sendRedirect(req.getRootPath() + "/job/" + this.getFullName() + "/" + this.getUrlName());
    }

    public List<String> getConfigs() throws InterruptedException, IOException {
        FilePath[] files;
        this.checkConfigurePermission();
        ArrayList<String> configs = new ArrayList<String>();
        FilePath dir = this.getStorableConfigsDir();
        for (FilePath filePath : files = dir.list("*.xml")) {
            configs.add(filePath.getName());
        }
        return configs;
    }

    public String getContent() throws IOException, InterruptedException {
        String filename = Stapler.getCurrentRequest().getParameter("file");
        FilePath file = new FilePath(this.getStorableConfigsDir(), filename);
        if (file.exists()) {
            return file.readToString();
        }
        return "<div>No such file</div>";
    }

    private void checkConfigurePermission() {
        this.project.checkPermission(Item.CONFIGURE);
    }

    private FilePath getStorableConfigsDir() throws InterruptedException, IOException {
        FilePath dir = new FilePath(this.getConfigsDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private File getConfigsDir() {
        return new File(this.project.getRootDir(), defaultDir);
    }
}

