/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor.model;

import hudson.plugins.sitemonitor.mapper.SuccessCodeListToCvString;
import java.util.List;

public class Site {
    private String mUrl;
    private Integer timeout;
    private List<Integer> successResponseCodes;
    private Boolean admitInsecureSslCerts = false;

    private Site(SiteBuilder builder) {
        this.mUrl = builder.url;
        this.timeout = builder.timeout;
        this.successResponseCodes = builder.successResponseCodes;
        this.admitInsecureSslCerts = builder.admitInsecureSslCerts;
    }

    public final String getUrl() {
        return this.mUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public List<Integer> getSuccessResponseCodes() {
        return this.successResponseCodes;
    }

    public final String getSuccessResponseCodesCsv() {
        return SuccessCodeListToCvString.INSTANCE.apply(this.successResponseCodes);
    }

    public Boolean getAdmitInsecureSslCerts() {
        return this.admitInsecureSslCerts;
    }

    public static SiteBuilder builder(String url) {
        return new SiteBuilder(url);
    }

    public static class SiteBuilder {
        private final String url;
        private Integer timeout;
        private List<Integer> successResponseCodes;
        private Boolean admitInsecureSslCerts = false;

        private SiteBuilder(String url) {
            this.url = url;
        }

        public SiteBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public SiteBuilder successResponseCodes(List<Integer> successResponseCodes) {
            this.successResponseCodes = successResponseCodes;
            return this;
        }

        public SiteBuilder admitInsecureSslCerts(boolean admitInsecureSslCerts) {
            this.admitInsecureSslCerts = admitInsecureSslCerts;
            return this;
        }

        public Site build() {
            return new Site(this);
        }
    }
}

