/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor.mapper;

import com.google.common.base.Function;
import hudson.plugins.sitemonitor.mapper.JsonToSuccessResponseList;
import hudson.plugins.sitemonitor.model.Site;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public enum JsonToSiteMapper implements Function<JSONObject, Site>
{
    INSTANCE;


    public Site apply(JSONObject json) {
        if (json != null) {
            String url = json.getString("url");
            if (!(url.startsWith("http://") || url.startsWith("https://") || url.contains("${"))) {
                url = "http://" + url;
            }
            Site.SiteBuilder siteBuilder = Site.builder(url);
            if (!StringUtils.isBlank((String)json.getString("timeout")) && NumberUtils.isDigits((String)json.getString("timeout"))) {
                siteBuilder.timeout(json.getInt("timeout"));
            }
            siteBuilder.successResponseCodes(JsonToSuccessResponseList.INSTANCE.apply(json));
            siteBuilder.admitInsecureSslCerts(json.containsKey((Object)"admitInsecureSslCerts") && json.getBoolean("admitInsecureSslCerts"));
            return siteBuilder.build();
        }
        return null;
    }
}

