/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor;

import hudson.plugins.sitemonitor.Messages;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class SiteMonitorValidator {
    public final FormValidation validateUrl(String url) {
        FormValidation validation = FormValidation.ok();
        if (StringUtils.isNotBlank((String)url)) {
            if (url.contains("://")) {
                if (!url.startsWith("http://") && !url.startsWith("https://")) {
                    validation = FormValidation.error((String)Messages.SiteMonitor_Error_PrefixOfURL());
                }
            } else if (!url.contains("${")) {
                String internalUrl = url;
                if (!url.startsWith("http://") && !url.startsWith("https://")) {
                    internalUrl = "http://" + internalUrl;
                }
                try {
                    new URL(internalUrl);
                }
                catch (MalformedURLException mue) {
                    validation = FormValidation.error((String)Messages.SiteMonitor_Error_MalformedURL());
                }
            }
        }
        return validation;
    }

    public final FormValidation validateTimeout(String timeout) {
        FormValidation validation = FormValidation.ok();
        if (StringUtils.isBlank((String)timeout)) {
            validation = FormValidation.error((String)Messages.SiteMonitor_Error_TimeoutIsBlank());
        } else if (!NumberUtils.isDigits((String)timeout)) {
            validation = FormValidation.error((String)Messages.SiteMonitor_Error_TimeoutIsNotDigit());
        }
        return validation;
    }

    public final FormValidation validateResponseCodes(String responseCodes) {
        FormValidation validation = FormValidation.ok();
        ArrayList<String> invalidResponseCodes = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)responseCodes)) {
            for (String responseCode : responseCodes.split(",")) {
                if (NumberUtils.isDigits((String)responseCode.trim())) continue;
                invalidResponseCodes.add(responseCode);
            }
        }
        if (!invalidResponseCodes.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer(Messages.SiteMonitor_Error_InvalidResponseCode());
            for (String invalidResponseCode : invalidResponseCodes) {
                errorMessage.append(invalidResponseCode).append(" ");
            }
            validation = FormValidation.error((String)errorMessage.toString());
        }
        return validation;
    }
}

