/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sitemonitor;

import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class SiteMonitorValidator {
    public final FormValidation validateUrl(String url) {
        FormValidation validation = FormValidation.ok();
        if (StringUtils.isNotBlank((String)url)) {
            if (url.startsWith("http://") || url.startsWith("https://")) {
                try {
                    new URL(url);
                }
                catch (MalformedURLException mue) {
                    validation = FormValidation.error((String)"URL is malformed");
                }
            } else {
                validation = FormValidation.error((String)"URL must start with http:// or https://");
            }
        }
        return validation;
    }

    public final FormValidation validateTimeout(String timeout) {
        FormValidation validation = FormValidation.ok();
        if (StringUtils.isBlank((String)timeout)) {
            validation = FormValidation.error((String)"Timeout value must be provided");
        } else if (!NumberUtils.isDigits((String)timeout)) {
            validation = FormValidation.error((String)"Timeout value must be a number");
        }
        return validation;
    }

    public final FormValidation validateResponseCodes(String responseCodes) {
        FormValidation validation = FormValidation.ok();
        ArrayList<String> invalidResponseCodes = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)responseCodes)) {
            for (String responseCode : responseCodes.split(",")) {
                if (NumberUtils.isDigits((String)responseCode.trim())) continue;
                invalidResponseCodes.add(responseCode);
            }
        }
        if (!invalidResponseCodes.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer("Invalid response code(s): ");
            for (String invalidResponseCode : invalidResponseCodes) {
                errorMessage.append(invalidResponseCode).append(" ");
            }
            validation = FormValidation.error((String)errorMessage.toString());
        }
        return validation;
    }
}

