/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.pmd.PmdMavenResultAction;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdReporterResult;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.parser.PmdParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

public class PmdReporter
extends HealthAwareReporter<PmdResult> {
    private static final long serialVersionUID = 2272875032054063496L;
    private static final String PLUGIN_NAME = "PMD";
    private static final String PMD_XML_FILE = "pmd.xml";
    @SuppressFBWarnings(value={""})
    private transient String pattern;

    @DataBoundConstructor
    public PmdReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, boolean canComputeNew) {
        super(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, usePreviousBuildAsReference, useStableBuildAsReference, canComputeNew, PLUGIN_NAME);
    }

    protected boolean acceptGoal(String goal) {
        return "pmd".equals(goal) || "site".equals(goal) || "report".equals(goal) || "check".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilesParser pmdCollector = new FilesParser(PLUGIN_NAME, PMD_XML_FILE, (AnnotationParser)new PmdParser(this.getDefaultEncoding()), this.getModuleName(pom));
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)pmdCollector);
    }

    protected PmdResult createResult(MavenBuild build, ParserResult project) {
        return new PmdReporterResult((Run<?, ?>)build, this.getDefaultEncoding(), project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
    }

    protected MavenAggregatedReport createMavenAggregatedReport(MavenBuild build, PmdResult result) {
        return new PmdMavenResultAction((AbstractBuild<?, ?>)build, (HealthDescriptor)this, this.getDefaultEncoding(), result);
    }

    public List<PmdProjectAction> getProjectActions(MavenModule module) {
        return Collections.singletonList(new PmdProjectAction((Job<?, ?>)module, (Class<? extends ResultAction<PmdResult>>)this.getResultActionClass()));
    }

    protected Class<PmdMavenResultAction> getResultActionClass() {
        return PmdMavenResultAction.class;
    }
}

