/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimedStreamCloser
extends Thread {
    private long seconds;
    private InputStream in;
    private long timeout;
    private boolean keepRunning = true;
    private boolean timedOut = false;
    private Object lock;

    public TimedStreamCloser(InputStream in, long timeout) throws IOException {
        this.in = in;
        this.timeout = timeout;
        this.lock = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.seconds = 0L;
        }
    }

    public void close() {
        this.keepRunning = false;
        try {
            this.in.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TimedStreamCloser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void run() {
        if (this.timeout < 0L) {
            return;
        }
        this.reset();
        while (this.keepRunning) {
            if (this.seconds > this.timeout) {
                this.timedOut = true;
                this.close();
                break;
            }
            try {
                Thread.sleep(1000L);
                ++this.seconds;
            }
            catch (InterruptedException ex) {
                this.close();
                break;
            }
        }
    }

    public boolean timedOut() {
        return this.timedOut;
    }
}

