/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.utils;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.perforce.PerforceSCM;
import hudson.plugins.perforce.utils.JobSubstitutionHelper;
import hudson.plugins.perforce.utils.NodeSubstitutionHelper;
import hudson.plugins.perforce.utils.ParameterSubstitutionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroStringHelper {
    public static final Level SUBSTITUTION_ERROR_LEVEL = Level.WARNING;

    public static String substituteParameters(@CheckForNull String string, @Nonnull PerforceSCM instance, @CheckForNull AbstractBuild build, @CheckForNull AbstractProject project, @CheckForNull Node node, @CheckForNull Map<String, String> env) throws ParameterSubstitutionException, InterruptedException {
        return build != null ? MacroStringHelper.substituteParameters(string, instance, build, env) : MacroStringHelper.substituteParameters(string, instance, project, node, env);
    }

    public static String substituteParameters(@CheckForNull String string, @Nonnull PerforceSCM instance, @CheckForNull AbstractProject project, @CheckForNull Node node, @CheckForNull Map<String, String> env) throws ParameterSubstitutionException, InterruptedException {
        if (string == null) {
            return null;
        }
        String result = MacroStringHelper.substituteParametersNoCheck(string, instance, project, node, env);
        MacroStringHelper.checkString(result);
        return result;
    }

    public static String substituteParameters(@CheckForNull String string, @Nonnull Map<String, String> subst) throws ParameterSubstitutionException {
        if (string == null) {
            return null;
        }
        String result = MacroStringHelper.substituteParametersNoCheck(string, subst);
        MacroStringHelper.checkString(result);
        return result;
    }

    public static String substituteParameters(@CheckForNull String string, @Nonnull PerforceSCM instance, @Nonnull AbstractBuild build, @CheckForNull Map<String, String> env) throws ParameterSubstitutionException, InterruptedException {
        if (string == null) {
            return null;
        }
        String result = MacroStringHelper.substituteParametersNoCheck(string, instance, build, env);
        MacroStringHelper.checkString(result);
        return result;
    }

    public static void checkString(@CheckForNull String string) throws ParameterSubstitutionException {
        if (MacroStringHelper.containsMacro(string)) {
            throw new ParameterSubstitutionException(string, "Found unresolved macro at '" + string + "'");
        }
    }

    private static String substituteParametersNoCheck(@CheckForNull String string, @Nonnull Map<String, String> subst) {
        if (string == null) {
            return null;
        }
        String newString = string;
        for (Map.Entry<String, String> entry : subst.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) continue;
            newString = newString.replace("${" + key + "}", value);
        }
        return newString;
    }

    public static boolean containsMacro(@CheckForNull String str) {
        return str != null && str.contains("${");
    }

    public static boolean containsVariable(@CheckForNull String str, @Nonnull String variableName) {
        return str != null && str.contains("${" + variableName + "}");
    }

    private static String substituteParametersNoCheck(@Nonnull String inputString, @Nonnull PerforceSCM instance, @CheckForNull AbstractProject project, @CheckForNull Node node, @CheckForNull Map<String, String> env) throws InterruptedException {
        if (!MacroStringHelper.containsMacro(inputString)) {
            return inputString;
        }
        String outputString = inputString;
        if (env != null && !env.isEmpty() && !MacroStringHelper.containsMacro(outputString = MacroStringHelper.substituteParametersNoCheck(outputString, env))) {
            return outputString;
        }
        HashMap<String, String> substitutions = new HashMap<String, String>();
        MacroStringHelper.getDefaultCoreSubstitutions(substitutions);
        NodeSubstitutionHelper.getDefaultNodeSubstitutions(instance, node, substitutions);
        if (project != null) {
            JobSubstitutionHelper.getDefaultSubstitutions(project, substitutions);
        }
        MacroStringHelper.getDefaultSubstitutions(instance, substitutions);
        outputString = MacroStringHelper.substituteParametersNoCheck(outputString, substitutions);
        return outputString;
    }

    private static String substituteParametersNoCheck(@Nonnull String inputString, @Nonnull PerforceSCM instance, @Nonnull AbstractBuild build, @CheckForNull Map<String, String> env) throws InterruptedException {
        if (!MacroStringHelper.containsMacro(inputString)) {
            return inputString;
        }
        String result = inputString;
        TreeMap<String, String> customVars = new TreeMap<String, String>();
        customVars.put("JOB_NAME", JobSubstitutionHelper.getSafeJobName(build));
        result = MacroStringHelper.substituteParametersNoCheck(result, customVars);
        TreeMap<String, String> environmentVarsFromExtensions = new TreeMap<String, String>();
        try {
            EnvVars vars = build.getEnvironment(TaskListener.NULL);
            environmentVarsFromExtensions.putAll((Map<String, String>)vars);
        }
        catch (IOException ex) {
            Logger.getLogger(PerforceSCM.class.getName()).log(Level.SEVERE, null, ex);
        }
        result = MacroStringHelper.substituteParametersNoCheck(result, environmentVarsFromExtensions);
        if (!MacroStringHelper.containsMacro(result)) {
            return result;
        }
        result = MacroStringHelper.substituteParametersNoCheck(result, instance, build.getProject(), build.getBuiltOn(), env);
        HashMap<String, String> substitutions = new HashMap<String, String>();
        MacroStringHelper.getDefaultBuildSubstitutions(build, substitutions);
        result = MacroStringHelper.substituteParametersNoCheck(result, substitutions);
        result = MacroStringHelper.substituteParametersNoCheck(result, build.getBuildVariables());
        return result;
    }

    private static void getDefaultCoreSubstitutions(@Nonnull Map<String, String> env) {
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null) {
            env.put("JENKINS_URL", rootUrl);
            env.put("HUDSON_URL", rootUrl);
        }
        env.put("JENKINS_HOME", Hudson.getInstance().getRootDir().getPath());
        env.put("HUDSON_HOME", Hudson.getInstance().getRootDir().getPath());
    }

    private static void getDefaultSubstitutions(@Nonnull PerforceSCM instance, @Nonnull Map<String, String> subst) {
        subst.put("P4USER", MacroStringHelper.substituteParametersNoCheck(instance.getEffectiveP4User(), subst));
    }

    private static void getDefaultBuildSubstitutions(@Nonnull AbstractBuild build, @Nonnull Map<String, String> subst) {
        String hudsonName = Hudson.getInstance().getDisplayName().toLowerCase();
        subst.put("BUILD_TAG", hudsonName + "-" + build.getProject().getName() + "-" + String.valueOf(build.getNumber()));
        subst.put("BUILD_ID", build.getId());
        subst.put("BUILD_NUMBER", String.valueOf(build.getNumber()));
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null) {
            subst.put("BUILD_URL", rootUrl + build.getUrl());
        }
    }
}

