/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.utils;

import hudson.matrix.Axis;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import java.util.Map;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobSubstitutionHelper {
    static void getDefaultSubstitutions(@Nonnull AbstractProject project, @Nonnull Map<String, String> subst) {
        subst.put("JOB_NAME", JobSubstitutionHelper.getSafeJobName(project));
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null) {
            subst.put("JOB_URL", rootUrl + project.getUrl());
        }
        for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
            if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
            subst.putAll((Map<String, String>)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
        }
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (pdp != null) {
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                try {
                    ParameterValue defaultValue = pd.getDefaultParameterValue();
                    if (defaultValue == null) continue;
                    String name = defaultValue.getName();
                    String value = (String)defaultValue.createVariableResolver(null).resolve(name);
                    subst.put(name, value);
                }
                catch (Exception e) {}
            }
        }
        if (project instanceof MatrixConfiguration) {
            MatrixConfiguration matrixConfiguration = (MatrixConfiguration)project;
            subst.putAll((Map<String, String>)matrixConfiguration.getCombination());
        }
        if (project instanceof MatrixProject) {
            MatrixProject matrixProject = (MatrixProject)project;
            for (Axis axis : matrixProject.getAxes()) {
                subst.put(axis.name, axis.size() > 0 ? axis.value(0) : "");
            }
        }
    }

    public static String getSafeJobName(@Nonnull AbstractBuild build) {
        return JobSubstitutionHelper.getSafeJobName(build.getProject());
    }

    public static String getSafeJobName(@Nonnull AbstractProject project) {
        return project.getFullName().replace('/', '-').replace('=', '-').replace(',', '-');
    }
}

