/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce.browsers;

import com.tek42.perforce.model.Changelist;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.plugins.perforce.PerforceChangeLogEntry;
import hudson.plugins.perforce.PerforceRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class Perfbrowse
extends PerforceRepositoryBrowser {
    public final URL url;
    public final String p4Describe = "?@describe+";
    public final String p4FileLog = "?@filelog+";
    public final String p4Diff = "?@diff+";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Perfbrowse(URL url) {
        this.url = url;
    }

    public URL getDiffLink(Changelist.FileEntry file) throws IOException {
        if (file.getAction() != Changelist.FileEntry.Action.EDIT && file.getAction() != Changelist.FileEntry.Action.INTEGRATE) {
            return null;
        }
        int r = new Integer(file.getRevision());
        if (r <= 1) {
            return null;
        }
        return new URL(this.url + "?@diff+" + file.getFilename() + "+" + r + "+" + (Object)((Object)file.getAction()));
    }

    public URL getFileLink(Changelist.FileEntry file) throws IOException {
        return new URL(this.url + "?@filelog+" + file.getFilename());
    }

    public URL getChangeSetLink(PerforceChangeLogEntry change) throws IOException {
        return new URL(this.url + "?@describe+" + change.getChangeNumber());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "Perfbrowse";
        }

        public FormValidation doCheck(final @QueryParameter String value) throws IOException, ServletException {
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)value);
                    if (url == null) {
                        return FormValidation.ok();
                    }
                    if (!url.startsWith("http://") && !url.startsWith("https://")) {
                        return FormValidation.errorWithMarkup((String)"The URL should contain <tt>http://</tt> or <tt>https://</tt>");
                    }
                    if (!url.endsWith(".cgi")) {
                        return FormValidation.errorWithMarkup((String)"The URL should end with a CGI script, usually <tt>perfbrowse.cgi</tt>");
                    }
                    return FormValidation.ok();
                }
            }.check();
        }

        public Perfbrowse newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Perfbrowse)((Object)req.bindParameters(Perfbrowse.class, "perfbrowse."));
        }
    }
}

