/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.perforce;

import com.tek42.perforce.model.User;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.perforce.PerforceSCM;
import hudson.plugins.perforce.PerforceUserProperty;
import hudson.tasks.MailAddressResolver;
import hudson.util.StreamTaskListener;
import java.util.logging.Logger;

@Extension
public class PerforceMailResolver
extends MailAddressResolver {
    private static final Logger LOGGER = Logger.getLogger(PerforceMailResolver.class.getName());

    public String findMailAddressFor(hudson.model.User u) {
        String email = this.findPerforceMailAddressFor(u);
        if (email == null) {
            return null;
        }
        if (email.matches(".+@.+")) {
            return email;
        }
        LOGGER.fine("Rejecting invalid email (" + email + ") retrieved from perforce.");
        return null;
    }

    public String findPerforceMailAddressFor(hudson.model.User u) {
        LOGGER.fine("Email address for " + u.getId() + " requested.");
        String perforceId = u.getId();
        PerforceUserProperty puprop = (PerforceUserProperty)u.getProperty(PerforceUserProperty.class);
        if (puprop != null) {
            if (puprop.getPerforceId() != null) {
                LOGGER.fine("Using perforce user id '" + perforceId + "' from " + u.getId() + "'s properties.");
                perforceId = puprop.getPerforceId();
            }
            if (puprop.getPerforceEmail() != null) {
                LOGGER.fine("Got email (" + puprop.getPerforceEmail() + ") from " + u.getId() + "'s P4 properties.");
                return puprop.getPerforceEmail();
            }
        }
        for (AbstractProject p : Hudson.getInstance().getAllItems(AbstractProject.class)) {
            if (!(p instanceof TopLevelItem) || p.isDisabled() || !(p.getScm() instanceof PerforceSCM)) continue;
            LOGGER.finer("Checking " + p.getName() + "'s Perforce SCM for " + perforceId + "'s address.");
            PerforceSCM pscm = (PerforceSCM)p.getScm();
            StreamTaskListener listener = new StreamTaskListener(System.out);
            Node node = p.getLastBuiltOn();
            if (node == null) {
                LOGGER.finer("Build doesn't seem to have been run before. Cannot resolve email address using this project.");
                continue;
            }
            if (node.getChannel() == null) {
                LOGGER.finer("Node " + node.getDisplayName() + " is not up, cannot resolve email address using this project.");
                continue;
            }
            for (int tries = 0; tries < 5; ++tries) {
                FilePath workspace = p.getLastBuiltOn().getRootPath();
                Launcher launcher = p.getLastBuiltOn().createLauncher((TaskListener)listener);
                User pu = null;
                try {
                    LOGGER.finer("Trying to get email address from perforce for " + perforceId);
                    pu = pscm.getDepot(launcher, workspace, p, null, node).getUsers().getUser(perforceId);
                    if (pu != null && pu.getEmail() != null && !pu.getEmail().equals("")) {
                        LOGGER.fine("Got email (" + pu.getEmail() + ") from perforce for " + perforceId);
                        return pu.getEmail();
                    }
                    return null;
                }
                catch (Exception e) {
                    LOGGER.fine("Could not get email address from Perforce: " + e.getMessage());
                    e.printStackTrace(listener.getLogger());
                    try {
                        Thread.sleep(tries);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        return null;
                    }
                }
            }
        }
        return null;
    }
}

