/*
 * Decompiled with CFR 0.152.
 */
package com.tek42.perforce;

import com.perforce.api.Env;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.parse.Changes;
import com.tek42.perforce.parse.Counters;
import com.tek42.perforce.parse.File;
import com.tek42.perforce.parse.Groups;
import com.tek42.perforce.parse.Labels;
import com.tek42.perforce.parse.Status;
import com.tek42.perforce.parse.Users;
import com.tek42.perforce.parse.Workspaces;
import com.tek42.perforce.process.DefaultExecutorFactory;
import com.tek42.perforce.process.Executor;
import com.tek42.perforce.process.ExecutorFactory;
import hudson.plugins.perforce.PerforcePasswordEncryptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Depot {
    private final transient Logger logger = LoggerFactory.getLogger((String)"perforce");
    private HashMap<String, String> settings = new HashMap();
    private String pathSep;
    private String fileSep;
    private boolean validEnvp;
    private String p4exe;
    private long threshold;
    private String p4Ticket;
    private String serverTimeZone;
    ExecutorFactory execFactory;
    private Changes changes;
    private Workspaces workspaces;
    private Users users;
    private Labels labels;
    private Status status;
    private Groups groups;
    private Counters counters;

    public Depot() {
        this(new DefaultExecutorFactory());
    }

    public Depot(ExecutorFactory factory) {
        String windir;
        this.setPassword("");
        this.setSystemDrive("C:");
        this.setSystemRoot("C:\\WINDOWS");
        this.setExecutable("p4");
        this.setServerTimeout(10000L);
        String os = System.getProperty("os.name");
        if (os == null) {
            return;
        }
        if (os.startsWith("Windows") && (windir = System.getProperty("com.ms.windir")) != null) {
            this.setSystemDrive(windir.substring(0, 1));
            this.setSystemRoot(windir);
        }
        this.execFactory = factory;
        this.validEnvp = false;
    }

    public ExecutorFactory getExecFactory() {
        if (!this.validEnvp) {
            HashMap<String, String> decryptCloneSettings = new HashMap<String, String>(this.settings);
            PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
            if (decryptCloneSettings.containsKey("P4PASSWD")) {
                decryptCloneSettings.put("P4PASSWD", encryptor.decryptString(decryptCloneSettings.get("P4PASSWD")));
            }
            this.execFactory.setEnv(decryptCloneSettings);
        }
        return this.execFactory;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Env getPerforceEnv() {
        Env env = new Env();
        env.setClient(this.getClient());
        env.setExecutable(this.getExecutable());
        env.setPassword(this.getPassword());
        env.setUser(this.getUser());
        env.setPort(this.getPort());
        env.setSystemDrive(this.getSystemDrive());
        env.setSystemRoot(this.getSystemRoot());
        return env;
    }

    public Changes getChanges() {
        if (this.changes == null) {
            this.changes = new Changes(this);
        }
        return this.changes;
    }

    public Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new Workspaces(this);
        }
        return this.workspaces;
    }

    public Users getUsers() {
        if (this.users == null) {
            this.users = new Users(this);
        }
        return this.users;
    }

    public Labels getLabels() {
        if (this.labels == null) {
            this.labels = new Labels(this);
        }
        return this.labels;
    }

    public Groups getGroups() {
        if (this.groups == null) {
            this.groups = new Groups(this);
        }
        return this.groups;
    }

    public Counters getCounters() {
        if (this.counters == null) {
            this.counters = new Counters(this);
        }
        return this.counters;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status(this);
        }
        return this.status;
    }

    public File getFile(String file) {
        return new File(this, file);
    }

    public String info() throws PerforceException {
        Executor p4 = this.getExecFactory().newExecutor();
        String[] cmd = new String[]{this.getExecutable(), "info"};
        p4.exec(cmd);
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = p4.getReader().readLine()) != null) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new PerforceException("Could not retrieve output of p4 info");
        }
    }

    public String getProperty(String key) {
        if (key.equals("P4PASSWD")) {
            String password = this.settings.get("P4PASSWD");
            PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
            return encryptor.decryptString(password);
        }
        return this.settings.get(key);
    }

    public String getProperty(String key, String def) {
        String value = this.getProperty(key);
        if (value == null || value.equals("")) {
            return def;
        }
        return value;
    }

    public void setUser(String user) {
        this.setenv("P4USER", user);
    }

    public String getUser() {
        return this.settings.get("P4USER");
    }

    public void setClient(String client) {
        this.setenv("P4CLIENT", client);
    }

    public String getClient() {
        return this.settings.get("P4CLIENT");
    }

    public void setPort(String port) {
        this.setenv("P4PORT", port);
    }

    public String getPort() {
        return this.settings.get("P4PORT");
    }

    public void setPassword(String password) {
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        this.setenv("P4PASSWD", encryptor.encryptString(password));
    }

    public String getPassword() {
        String password = this.settings.get("P4PASSWD");
        PerforcePasswordEncryptor encryptor = new PerforcePasswordEncryptor();
        return encryptor.decryptString(password);
    }

    public void setPath(String path) {
        this.setenv("PATH", path);
    }

    public String getCharset() {
        return this.settings.get("P4CHARSET");
    }

    public void setCharset(String charset) {
        this.setenv("P4CHARSET", charset);
    }

    public String getCommandCharset() {
        return this.settings.get("P4COMMANDCHARSET");
    }

    public void setCommandCharset(String charset) {
        this.setenv("P4COMMANDCHARSET", charset);
    }

    public void appendPath(String path) {
        if (null == path) {
            return;
        }
        String origPath = this.getProperty("PATH");
        if (null == this.pathSep || null == origPath) {
            this.setPath(path);
            return;
        }
        StringTokenizer st = new StringTokenizer(origPath, this.pathSep);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals(path)) {
                return;
            }
            sb.append(tok);
            sb.append(this.pathSep);
        }
        sb.append(path);
        this.setPath(path);
    }

    public String getPath() {
        return this.settings.get("PATH");
    }

    public void setSystemDrive(String drive) {
        this.setenv("SystemDrive", drive);
    }

    public String getSystemDrive() {
        return this.settings.get("SystemDrive");
    }

    public void setSystemRoot(String root) {
        this.setenv("SystemRoot", root);
    }

    public String getSystemRoot() {
        return this.settings.get("SystemRoot");
    }

    public void setExecutable(String exe) {
        if (null == exe) {
            return;
        }
        this.p4exe = exe;
    }

    public String getExecutable() {
        return this.p4exe;
    }

    public void setServerTimeout(long threshold) {
        this.threshold = threshold;
    }

    public long getServerTimeout() {
        return this.threshold;
    }

    public String getP4Ticket() {
        return this.p4Ticket;
    }

    @CheckForNull
    public String getServerTimezone() {
        if (this.serverTimeZone == null) {
            StringTokenizer infoTokens;
            try {
                infoTokens = new StringTokenizer(this.info(), "\n");
            }
            catch (PerforceException ex) {
                return null;
            }
            while (infoTokens.hasMoreTokens()) {
                String infoLine = infoTokens.nextToken();
                if (!infoLine.startsWith("Server date: ")) continue;
                this.serverTimeZone = infoLine.substring(33, 38);
                break;
            }
        }
        return this.serverTimeZone;
    }

    public void setP4Ticket(String ticket) {
        this.p4Ticket = ticket;
    }

    private void setenv(String key, String newValue) {
        String currentValue;
        if (newValue != null && (newValue = newValue.trim()).length() == 0) {
            newValue = null;
        }
        if (Depot.safeEquals(newValue, currentValue = this.settings.get(key))) {
            return;
        }
        if (newValue == null) {
            this.settings.remove(key);
        } else {
            this.settings.put(key, newValue);
        }
        this.validEnvp = false;
    }

    public static boolean safeEquals(String newValue, String currentValue) {
        if (newValue == null) {
            return currentValue == null;
        }
        return newValue.equals(currentValue);
    }
}

